/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5756")
public class NonCallableCalledCheck
extends PythonSubscriptionCheck {
    private static final List<String> NON_CALLABLE_TYPES = Arrays.asList("set", "frozenset");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            block5: {
                String name;
                InferredType calleeType;
                Expression callee;
                block4: {
                    CallExpression callExpression = (CallExpression)ctx.syntaxNode();
                    callee = callExpression.callee();
                    calleeType = callee.type();
                    if (!calleeType.canHaveMember("__call__")) break block4;
                    if (!NON_CALLABLE_TYPES.stream().anyMatch(arg_0 -> ((InferredType)calleeType).canOnlyBe(arg_0))) break block5;
                }
                PythonCheck.PreciseIssue preciseIssue = (name = NonCallableCalledCheck.nameFromExpression(callee)) != null ? ctx.addIssue((Tree)callee, String.format("Fix this call; \"%s\"%s is not callable.", name, NonCallableCalledCheck.addTypeName(calleeType))) : ctx.addIssue((Tree)callee, String.format("Fix this call; this expression%s is not callable.", NonCallableCalledCheck.addTypeName(calleeType)));
                LocationInFile location = InferredTypes.typeClassLocation((InferredType)calleeType);
                if (location != null) {
                    preciseIssue.secondary(location, null);
                }
            }
        });
    }

    private static String nameFromExpression(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            return ((Name)expression).name();
        }
        return null;
    }

    private static String addTypeName(InferredType type) {
        String typeName = InferredTypes.typeName((InferredType)type);
        if (typeName != null) {
            return " has type " + typeName + " and it";
        }
        return "";
    }
}

