/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5724")
public class PropertyAccessorParameterCountCheck
extends PythonSubscriptionCheck {
    private static long countRequiredParameters(FunctionDef functionDef) {
        ParameterList parameterList = functionDef.parameters();
        if (parameterList == null) {
            return 0L;
        }
        return parameterList.all().stream().filter(p -> p.is(new Tree.Kind[]{Tree.Kind.TUPLE_PARAMETER}) || p.is(new Tree.Kind[]{Tree.Kind.PARAMETER}) && ((Parameter)p).defaultValue() == null).count();
    }

    private static void checkOnlySelfParameter(SubscriptionContext ctx, FunctionDef functionDef, String messageTemplate) {
        long actualParams = PropertyAccessorParameterCountCheck.countRequiredParameters(functionDef);
        if (actualParams > 1L) {
            ctx.addIssue(functionDef.defKeyword(), functionDef.rightPar(), String.format(messageTemplate, actualParams - 1L));
        }
    }

    private static void checkSetterParameters(SubscriptionContext ctx, FunctionDef functionDef) {
        long requiredParameters = PropertyAccessorParameterCountCheck.countRequiredParameters(functionDef);
        if (requiredParameters > 2L) {
            ctx.addIssue(functionDef.defKeyword(), functionDef.rightPar(), String.format("Remove %d parameters; property setter methods receive \"self\" and a value.", requiredParameters - 2L));
        } else if (requiredParameters < 2L && TreeUtils.positionalParameters((FunctionDef)functionDef).size() < 2) {
            ctx.addIssue(functionDef.defKeyword(), functionDef.rightPar(), "Add the value parameter; property setter methods receive \"self\" and a value.");
        }
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            CollectPropertiesVisitor visitor = new CollectPropertiesVisitor();
            classDef.body().accept((TreeVisitor)visitor);
            List<PropertyAccessorTriple> propertyAccessors = visitor.propertyAccessors();
            for (PropertyAccessorTriple triple : propertyAccessors) {
                triple.getter.ifPresent(functionDef -> PropertyAccessorParameterCountCheck.checkOnlySelfParameter(ctx, functionDef, "Remove %d parameters; property getter methods receive only \"self\"."));
                triple.setter.ifPresent(functionDef -> PropertyAccessorParameterCountCheck.checkSetterParameters(ctx, functionDef));
                triple.deleter.ifPresent(functionDef -> PropertyAccessorParameterCountCheck.checkOnlySelfParameter(ctx, functionDef, "Remove %d parameters; property deleter methods receive only \"self\"."));
            }
        });
    }

    private static class CollectPropertiesVisitor
    extends BaseTreeVisitor {
        private Map<String, PropertyAccessorTriple> decoratorStyleProperties = new HashMap<String, PropertyAccessorTriple>();
        private List<PropertyAccessorTriple> propertyCallStyleProperties = new ArrayList<PropertyAccessorTriple>();

        private CollectPropertiesVisitor() {
        }

        private static Optional<FunctionDef> findFunctionDefFromArgument(List<RegularArgument> arguments, int position) {
            if (arguments.size() <= position) {
                return Optional.empty();
            }
            RegularArgument argument = arguments.get(position);
            Expression argumentExpr = argument.expression();
            if (!(argumentExpr instanceof HasSymbol)) {
                return Optional.empty();
            }
            Symbol symbol = ((HasSymbol)argumentExpr).symbol();
            if (symbol == null) {
                return Optional.empty();
            }
            return symbol.usages().stream().filter(usage -> usage.kind() == Usage.Kind.FUNC_DECLARATION).map(usage -> usage.tree().parent()).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})).map(FunctionDef.class::cast).findFirst();
        }

        public void visitCallExpression(CallExpression pyCallExpressionTree) {
            Symbol callee = pyCallExpressionTree.calleeSymbol();
            if (callee == null || !"property".equals(callee.name())) {
                return;
            }
            List argumentList = pyCallExpressionTree.arguments();
            List<RegularArgument> regularArguments = argumentList.stream().filter(arg -> arg.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})).map(RegularArgument.class::cast).collect(Collectors.toList());
            if (regularArguments.size() != argumentList.size() || regularArguments.stream().anyMatch(arg -> arg.keywordArgument() != null)) {
                return;
            }
            PropertyAccessorTriple triple = new PropertyAccessorTriple();
            triple.getter = CollectPropertiesVisitor.findFunctionDefFromArgument(regularArguments, 0);
            triple.setter = CollectPropertiesVisitor.findFunctionDefFromArgument(regularArguments, 1);
            triple.deleter = CollectPropertiesVisitor.findFunctionDefFromArgument(regularArguments, 2);
            this.propertyCallStyleProperties.add(triple);
        }

        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            boolean hasPropertyDecorator = pyFunctionDefTree.decorators().stream().map(decorator -> decorator.name().names()).anyMatch(names -> names.size() == 1 && "property".equals(((Name)names.get(0)).name()));
            if (hasPropertyDecorator) {
                this.decoratorStyleProperties.compute(pyFunctionDefTree.name().name(), (key, value) -> {
                    if (value == null) {
                        value = new PropertyAccessorTriple();
                    }
                    ((PropertyAccessorTriple)value).getter = Optional.of(pyFunctionDefTree);
                    return value;
                });
                return;
            }
            Optional<List> setterOrDeleterDecoratorNames = pyFunctionDefTree.decorators().stream().map(decorator -> decorator.name().names()).filter(names -> names.size() == 2 && ("setter".equals(((Name)names.get(1)).name()) || "deleter".equals(((Name)names.get(1)).name()))).findFirst();
            setterOrDeleterDecoratorNames.ifPresent(names -> {
                String propertyName = ((Name)names.get(0)).name();
                String accessor = ((Name)names.get(1)).name();
                this.decoratorStyleProperties.compute(propertyName, (key, value) -> {
                    if (value == null) {
                        value = new PropertyAccessorTriple();
                    }
                    if ("setter".equals(accessor)) {
                        ((PropertyAccessorTriple)value).setter = Optional.of(pyFunctionDefTree);
                    } else if ("deleter".equals(accessor)) {
                        ((PropertyAccessorTriple)value).deleter = Optional.of(pyFunctionDefTree);
                    }
                    return value;
                });
            });
        }

        public void visitClassDef(ClassDef pyClassDefTree) {
        }

        public List<PropertyAccessorTriple> propertyAccessors() {
            return Stream.concat(this.propertyCallStyleProperties.stream(), this.decoratorStyleProperties.values().stream()).collect(Collectors.toList());
        }
    }

    private static class PropertyAccessorTriple {
        private Optional<FunctionDef> getter = Optional.empty();
        private Optional<FunctionDef> setter = Optional.empty();
        private Optional<FunctionDef> deleter = Optional.empty();

        private PropertyAccessorTriple() {
        }
    }
}

