/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.python.checks.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5122")
public class CorsCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make sure this permissive CORS policy is safe here.";
    private static final String DJANGO_ALLOW_ALL = "CORS_ORIGIN_ALLOW_ALL";
    private static final String DJANGO_WHITELIST = "CORS_ORIGIN_REGEX_WHITELIST";
    private static final String STAR = "*";
    private static final List<String> REGEX_TO_REPORT = Arrays.asList(".*", ".+", "^.*$", "^.+$", ".*$", ".+$", "^.*", "^.+", "*");
    private static final String ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String ORIGINS = "origins";
    private static final List<String> TYPES_TO_CHECK = Arrays.asList("django.http.HttpResponse", "django.http.response.HttpResponse", "werkzeug.datastructures.Headers");
    private static final List<String> REQUEST_SET_HEADER_QUALIFIER = Arrays.asList("headers", "add");
    private static final String WERKZEUG_BASERESPONSE_HEADERS = "werkzeug.wrappers.BaseResponse.headers";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, CorsCheck::checkDjangoSettings);
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, CorsCheck::checkAllowOriginProperty);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, CorsCheck::checkDjangoResponseSetItem);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, CorsCheck::checkFlaskCorsCall);
        context.registerSyntaxNodeConsumer(Tree.Kind.DECORATOR, CorsCheck::checkFlaskDecorator);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, CorsCheck::checkFlaskResponse);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, CorsCheck::checkWerkzeugHeaders);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, CorsCheck::checkResponseHeadersAdd);
    }

    private static void checkDjangoSettings(SubscriptionContext ctx) {
        if (!ctx.pythonFile().fileName().equals("settings.py")) {
            return;
        }
        AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
        if (CorsCheck.isVarAssignment(assignment, DJANGO_ALLOW_ALL) && assignment.assignedValue().is(new Tree.Kind[]{Tree.Kind.NAME}) && ((Name)assignment.assignedValue()).name().equals("True")) {
            ctx.addIssue((Tree)assignment, MESSAGE);
        } else if (CorsCheck.isVarAssignment(assignment, DJANGO_WHITELIST)) {
            CorsCheck.getSingleElementInList(assignment.assignedValue()).ifPresent(element -> {
                if (CorsCheck.isString((Tree)element, REGEX_TO_REPORT)) {
                    ctx.addIssue((Tree)assignment, MESSAGE);
                }
            });
        }
    }

    private static void checkAllowOriginProperty(SubscriptionContext ctx) {
        AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
        Optional<Expression> lhs = CorsCheck.getOnlyAssignedLhs(assignment);
        if (lhs.isPresent() && lhs.get().is(new Tree.Kind[]{Tree.Kind.SUBSCRIPTION})) {
            SubscriptionExpression subscription = (SubscriptionExpression)lhs.get();
            List subscripts = subscription.subscripts().expressions();
            if (subscripts.size() != 1) {
                return;
            }
            if (subscription.object().is(new Tree.Kind[]{Tree.Kind.NAME}) && TYPES_TO_CHECK.stream().anyMatch(t -> subscription.object().type().canOnlyBe(t))) {
                CorsCheck.reportIfAllowOriginIsSet(ctx, assignment, (Expression)subscripts.get(0));
            } else {
                CorsCheck.checkAllowOriginPropertyQualifiedExpr(ctx, assignment, subscription, subscripts);
            }
        }
    }

    private static void checkAllowOriginPropertyQualifiedExpr(SubscriptionContext ctx, AssignmentStatement assignment, SubscriptionExpression subscr, List<Expression> subscripts) {
        if (subscr.object().is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) {
            if (CorsCheck.isSymbol(((QualifiedExpression)subscr.object()).symbol(), WERKZEUG_BASERESPONSE_HEADERS)) {
                CorsCheck.reportIfAllowOriginIsSet(ctx, assignment, subscripts.get(0));
            } else {
                Expression value;
                Expression expr = CorsCheck.getQualifierPrecedingNameSequence(subscr.object(), Collections.singletonList("headers"));
                if (expr != null && expr.is(new Tree.Kind[]{Tree.Kind.NAME}) && (value = Expressions.singleAssignedValue((Name)expr)) != null && value.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && CorsCheck.getQualifierPrecedingNameSequence(((CallExpression)value).callee(), Collections.singletonList("Response")) != null) {
                    CorsCheck.reportIfAllowOriginIsSet(ctx, assignment, subscripts.get(0));
                }
            }
        }
    }

    private static void reportIfAllowOriginIsSet(SubscriptionContext ctx, AssignmentStatement assignment, Expression expression) {
        if (CorsCheck.isString((Tree)expression, ALLOW_ORIGIN) && CorsCheck.isString((Tree)assignment.assignedValue(), STAR)) {
            ctx.addIssue((Tree)assignment, MESSAGE);
        }
    }

    private static void checkDjangoResponseSetItem(SubscriptionContext ctx) {
        CorsCheck.reportOnSetMethod(ctx, "django.http.response.HttpResponseBase.__setitem__");
    }

    private static void reportOnSetMethod(SubscriptionContext ctx, String fqn) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (callExpression.arguments().size() == 2 && CorsCheck.isSymbol(calleeSymbol, fqn)) {
            CorsCheck.reportIfAllowOriginIsStar(ctx, callExpression);
        }
    }

    private static Expression getQualifierPrecedingNameSequence(Expression expression, List<String> nameParts) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR}) && nameParts.get(nameParts.size() - 1).equals(((QualifiedExpression)expression).name().name())) {
            if (nameParts.size() != 1) {
                return CorsCheck.getQualifierPrecedingNameSequence(((QualifiedExpression)expression).qualifier(), nameParts.subList(0, nameParts.size() - 1));
            }
            return ((QualifiedExpression)expression).qualifier();
        }
        return null;
    }

    private static boolean firstParameterOfFunctionMatchesName(FunctionDef functionDef, String targetName) {
        ParameterList parameterList = functionDef.parameters();
        if (parameterList != null) {
            return parameterList.nonTuple().stream().findFirst().map(Parameter::name).map(Name::name).map(targetName::equals).orElse(false);
        }
        return false;
    }

    private static void checkResponseHeadersAdd(SubscriptionContext ctx) {
        Expression parent;
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (callExpression.arguments().size() == 2 && (parent = CorsCheck.getQualifierPrecedingNameSequence(callExpression.callee(), REQUEST_SET_HEADER_QUALIFIER)) != null && parent.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            FunctionDef functionDef = (FunctionDef)TreeUtils.firstAncestorOfKind((Tree)callExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF});
            String objectName = ((Name)parent).name();
            if (functionDef != null && CorsCheck.firstParameterOfFunctionMatchesName(functionDef, objectName)) {
                CorsCheck.reportIfAllowOriginIsStar(ctx, callExpression);
            }
        }
    }

    private static void reportIfAllowOriginIsStar(SubscriptionContext ctx, CallExpression callExpression) {
        Argument arg0 = (Argument)callExpression.arguments().get(0);
        Argument arg1 = (Argument)callExpression.arguments().get(1);
        if (CorsCheck.isString((Tree)arg0, ALLOW_ORIGIN) && CorsCheck.isString((Tree)arg1, STAR)) {
            ctx.addIssue((Tree)callExpression, MESSAGE);
        }
    }

    private static void checkFlaskDecorator(SubscriptionContext ctx) {
        Symbol symbol;
        Decorator decorator = (Decorator)ctx.syntaxNode();
        List names = decorator.name().names();
        if (names.size() == 1 && CorsCheck.isSymbol(symbol = ((Name)names.get(0)).symbol(), "flask_cors.cross_origin")) {
            ArgList arguments = decorator.arguments();
            if (arguments == null) {
                ctx.addIssue((Tree)decorator, MESSAGE);
                return;
            }
            CorsCheck.getArgument(arguments.arguments(), ORIGINS).ifPresent(argument -> {
                if (CorsCheck.originsToReport(argument)) {
                    ctx.addIssue((Tree)decorator, MESSAGE);
                }
            });
        }
    }

    private static void checkWerkzeugHeaders(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Symbol symbol = callExpression.calleeSymbol();
        if (CorsCheck.isSymbol(symbol, "werkzeug.datastructures.Headers") && callExpression.arguments().size() == 1) {
            CorsCheck.reportOnHeader(ctx, (Argument)callExpression.arguments().get(0));
        } else {
            CorsCheck.reportOnSetMethod(ctx, "werkzeug.datastructures.Headers.set");
            CorsCheck.reportOnSetMethod(ctx, "werkzeug.datastructures.Headers.setdefault");
            CorsCheck.reportOnSetMethod(ctx, "werkzeug.datastructures.Headers.__setitem__");
        }
    }

    private static void checkFlaskResponse(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Symbol symbol = callExpression.calleeSymbol();
        if (CorsCheck.isSymbol(symbol, "flask.Response") || CorsCheck.isSymbol(symbol, "flask.wrappers.Response")) {
            if (callExpression.arguments().size() > 2) {
                Argument argument = (Argument)callExpression.arguments().get(2);
                CorsCheck.reportOnHeader(ctx, argument);
            }
        } else if (CorsCheck.isSymbol(symbol, "flask.make_response") || CorsCheck.isSymbol(symbol, "flask.helpers.make_response")) {
            List elements;
            if (callExpression.arguments().size() != 1) {
                return;
            }
            Argument argument = (Argument)callExpression.arguments().get(0);
            if (argument.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT}) && ((RegularArgument)argument).expression().is(new Tree.Kind[]{Tree.Kind.TUPLE}) && !(elements = ((Tuple)((RegularArgument)argument).expression()).elements()).isEmpty()) {
                CorsCheck.reportOnHeader(ctx, (Expression)elements.get(elements.size() - 1));
            }
        }
    }

    private static <T extends Tree> void reportOnHeader(SubscriptionContext ctx, T element) {
        CorsCheck.getValueInDictionary(element, ALLOW_ORIGIN).ifPresent(value -> {
            if (CorsCheck.isString((Tree)value, STAR)) {
                ctx.addIssue(element, MESSAGE);
            }
        });
    }

    private static void checkFlaskCorsCall(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (!CorsCheck.isSymbol(calleeSymbol, "flask_cors.CORS")) {
            return;
        }
        if (callExpression.arguments().size() == 1) {
            ctx.addIssue((Tree)callExpression, MESSAGE);
            return;
        }
        Optional<Expression> originsArgument = CorsCheck.getArgument(callExpression.arguments(), ORIGINS);
        originsArgument.ifPresent(argument -> {
            if (CorsCheck.originsToReport(argument)) {
                ctx.addIssue((Tree)callExpression, MESSAGE);
            }
        });
        Optional<Expression> resourcesArgumentOpt = CorsCheck.getArgument(callExpression.arguments(), "resources");
        if (!resourcesArgumentOpt.isPresent()) {
            return;
        }
        Expression resourcesArgument = resourcesArgumentOpt.get();
        if (resourcesArgument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && !originsArgument.isPresent()) {
            ctx.addIssue((Tree)callExpression, MESSAGE);
        } else if (resourcesArgument.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})) {
            List elements = ((DictionaryLiteral)resourcesArgument).elements();
            CorsCheck.checkResourcesElements(ctx, callExpression, elements);
        }
    }

    private static void checkResourcesElements(SubscriptionContext ctx, CallExpression callExpression, List<DictionaryLiteralElement> elements) {
        for (DictionaryLiteralElement element : elements) {
            Optional<Expression> originsValue;
            if (!element.is(new Tree.Kind[]{Tree.Kind.KEY_VALUE_PAIR}) || !(originsValue = CorsCheck.getValueInDictionary((Tree)((KeyValuePair)element).value(), ORIGINS)).isPresent() || !CorsCheck.originsToReport(originsValue.get())) continue;
            ctx.addIssue((Tree)callExpression, MESSAGE);
            return;
        }
    }

    private static boolean originsToReport(Expression origins) {
        if (origins.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && REGEX_TO_REPORT.contains(((StringLiteral)origins).trimmedQuotesValue())) {
            return true;
        }
        Optional<Expression> element = CorsCheck.getSingleElementInList(origins);
        return element.isPresent() && CorsCheck.isString((Tree)element.get(), STAR);
    }

    private static Optional<Expression> getValueInDictionary(Tree tree, String key) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})) {
            List elements = ((DictionaryLiteral)tree).elements();
            for (DictionaryLiteralElement element : elements) {
                KeyValuePair keyValuePair;
                if (!element.is(new Tree.Kind[]{Tree.Kind.KEY_VALUE_PAIR}) || !CorsCheck.isString((Tree)(keyValuePair = (KeyValuePair)elements.get(0)).key(), key)) continue;
                return Optional.of(keyValuePair.value());
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) {
            return CorsCheck.getValueInDictionary((Tree)((RegularArgument)tree).expression(), key);
        }
        return Optional.empty();
    }

    private static Optional<Expression> getSingleElementInList(Expression expression) {
        ListLiteral listLiteral;
        if (expression.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL}) && (listLiteral = (ListLiteral)expression).elements().expressions().size() == 1) {
            return Optional.of((Expression)listLiteral.elements().expressions().get(0));
        }
        return Optional.empty();
    }

    private static boolean isString(Tree tree, String value) {
        return CorsCheck.isString(tree, Collections.singletonList(value));
    }

    private static boolean isString(Tree tree, List<String> values) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return values.contains(((StringLiteral)tree).trimmedQuotesValue());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})) {
            return CorsCheck.isString((Tree)((RegularArgument)tree).expression(), values);
        }
        return false;
    }

    private static boolean isVarAssignment(AssignmentStatement assignment, String nameValue) {
        Optional<Expression> lhs = CorsCheck.getOnlyAssignedLhs(assignment);
        return lhs.isPresent() && lhs.get().is(new Tree.Kind[]{Tree.Kind.NAME}) && ((Name)lhs.get()).name().equals(nameValue);
    }

    private static Optional<Expression> getOnlyAssignedLhs(AssignmentStatement assignment) {
        List lhs = assignment.lhsExpressions();
        if (lhs.size() == 1 && ((ExpressionList)lhs.get(0)).expressions().size() == 1) {
            return Optional.of((Expression)((ExpressionList)lhs.get(0)).expressions().get(0));
        }
        return Optional.empty();
    }

    private static Optional<Expression> getArgument(List<Argument> arguments, String keyword) {
        return arguments.stream().filter(a -> a.is(new Tree.Kind[]{Tree.Kind.REGULAR_ARGUMENT})).map(a -> (RegularArgument)a).filter(a -> a.keywordArgument() != null && a.keywordArgument().name().equals(keyword)).map(RegularArgument::expression).findAny();
    }

    private static boolean isSymbol(@Nullable Symbol symbol, String fqn) {
        return symbol != null && symbol.fullyQualifiedName() != null && fqn.equals(symbol.fullyQualifiedName());
    }
}

