/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.InExpression;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.IncompatibleOperands;
import org.sonar.python.checks.ItemOperationsType;
import org.sonar.python.checks.IterationOnNonIterable;
import org.sonar.python.checks.NonCallableCalled;
import org.sonar.python.checks.SillyEquality;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;
import org.sonar.python.types.TypeShed;

@Rule(key="S5864")
public class ConfusingTypeCheckingCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        new NonCallableCalledCheck().initialize(context);
        new IncompatibleOperandsCheck().initialize(context);
        new ItemOperationsTypeCheck().initialize(context);
        new IterationOnNonIterableCheck().initialize(context);
        new SillyEqualityCheck().initialize(context);
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ConfusingTypeCheckingCheck::checkIncorrectExceptionType);
        context.registerSyntaxNodeConsumer(Tree.Kind.IS, ConfusingTypeCheckingCheck::checkSillyIdentity);
    }

    private static void checkIncorrectExceptionType(SubscriptionContext ctx) {
        RaiseStatement raiseStatement = (RaiseStatement)ctx.syntaxNode();
        if (raiseStatement.expressions().isEmpty()) {
            return;
        }
        Expression raisedExpression = (Expression)raiseStatement.expressions().get(0);
        InferredType type = raisedExpression.type();
        if (!InferredTypes.containsDeclaredType((InferredType)type)) {
            return;
        }
        if (!type.isCompatibleWith(InferredTypes.runtimeType((Symbol)TypeShed.typeShedClass((String)"BaseException")))) {
            String expressionName = TreeUtils.nameFromExpression((Expression)raisedExpression) != null ? String.format("\"%s\"", TreeUtils.nameFromExpression((Expression)raisedExpression)) : "this expression";
            String typeName = InferredTypes.typeName((InferredType)type);
            ctx.addIssue((Tree)raiseStatement, String.format("Fix this \"raise\" statement; Previous type checks suggest that %s has type \"%s\" and is not an exception.", expressionName, typeName));
        }
    }

    private static boolean areIdentityComparableOrNone(InferredType leftType, InferredType rightType) {
        if (!InferredTypes.containsDeclaredType((InferredType)leftType) && !InferredTypes.containsDeclaredType((InferredType)rightType)) {
            return true;
        }
        Collection leftSymbols = InferredTypes.typeSymbols((InferredType)leftType);
        Collection rightSymbols = InferredTypes.typeSymbols((InferredType)rightType);
        return leftSymbols.stream().map(Symbol::fullyQualifiedName).anyMatch(fqn -> fqn == null || rightSymbols.stream().anyMatch(rs -> rs.canBeOrExtend(fqn))) || rightSymbols.stream().map(Symbol::fullyQualifiedName).anyMatch(fqn -> fqn == null || leftSymbols.stream().anyMatch(ls -> ls.canBeOrExtend(fqn))) || InferredTypes.typeSymbols((InferredType)leftType).stream().map(Symbol::fullyQualifiedName).allMatch("NoneType"::equals) || InferredTypes.typeSymbols((InferredType)rightType).stream().map(Symbol::fullyQualifiedName).allMatch("NoneType"::equals);
    }

    private static void checkSillyIdentity(SubscriptionContext ctx) {
        InferredType right;
        IsExpression isExpression = (IsExpression)ctx.syntaxNode();
        InferredType left = isExpression.leftOperand().type();
        if (!ConfusingTypeCheckingCheck.areIdentityComparableOrNone(left, right = isExpression.rightOperand().type())) {
            Token notToken = isExpression.notToken();
            Token lastToken = notToken == null ? isExpression.operator() : notToken;
            ctx.addIssue(isExpression.operator(), lastToken, "Fix this identity check; Previous type checks suggest that operands have incompatible types.");
        }
    }

    private static class SillyEqualityCheck
    extends SillyEquality {
        private SillyEqualityCheck() {
        }

        @Override
        boolean areIdentityComparableOrNone(InferredType leftType, InferredType rightType) {
            return ConfusingTypeCheckingCheck.areIdentityComparableOrNone(leftType, rightType);
        }

        @Override
        public boolean canImplementEqOrNe(Expression expression) {
            InferredType type = expression.type();
            return type.declaresMember("__eq__") || type.declaresMember("__ne__");
        }

        @Override
        @CheckForNull
        String builtinTypeCategory(InferredType inferredType) {
            return BUILTINS_TYPE_CATEGORY.keySet().stream().filter(typeName -> InferredTypes.typeSymbols((InferredType)inferredType).stream().map(Symbol::fullyQualifiedName).allMatch(typeName::equals)).map(BUILTINS_TYPE_CATEGORY::get).findFirst().orElse(null);
        }

        @Override
        String message(String result) {
            return "Fix this equality check; Previous type checks suggest that operands have incompatible types.";
        }
    }

    private static class IterationOnNonIterableCheck
    extends IterationOnNonIterable {
        private IterationOnNonIterableCheck() {
        }

        @Override
        boolean isValidIterable(Expression expression, List<LocationInFile> secondaries) {
            InferredType type = expression.type();
            secondaries.add(InferredTypes.typeClassLocation((InferredType)type));
            return !InferredTypes.containsDeclaredType((InferredType)type) || type.declaresMember("__iter__") || type.declaresMember("__getitem__");
        }

        @Override
        String message(Expression expression, boolean isForLoop) {
            String typeName = InferredTypes.typeName((InferredType)expression.type());
            String expressionName = TreeUtils.nameFromExpression((Expression)expression);
            String expressionNameString = expressionName != null ? String.format("\"%s\"", expressionName) : "it";
            String typeNameString = typeName != null ? String.format("has type \"%s\" and", typeName) : "";
            return isForLoop && this.isAsyncIterable(expression) ? String.format("Add \"async\" before \"for\"; Previous type checks suggest that %s %s is an async generator.", expressionNameString, typeNameString) : String.format("Replace this expression; Previous type checks suggest that %s %s isn't iterable.", expressionNameString, typeNameString);
        }

        @Override
        boolean isAsyncIterable(Expression expression) {
            InferredType type = expression.type();
            return type.declaresMember("__aiter__");
        }
    }

    private static class ItemOperationsTypeCheck
    extends ItemOperationsType {
        private ItemOperationsTypeCheck() {
        }

        @Override
        public boolean isValidSubscription(Expression subscriptionObject, String requiredMethod, @Nullable String classRequiredMethod, List<LocationInFile> secondaries) {
            InferredType type = subscriptionObject.type();
            secondaries.add(InferredTypes.typeClassLocation((InferredType)type));
            if (!InferredTypes.containsDeclaredType((InferredType)type)) {
                return true;
            }
            return ItemOperationsTypeCheck.isUsedInsideInExpression(subscriptionObject) || type.declaresMember(requiredMethod);
        }

        private static boolean isUsedInsideInExpression(Expression subscriptionObject) {
            return TreeUtils.getSymbolFromTree((Tree)subscriptionObject).filter(symbol -> symbol.usages().stream().anyMatch(usage -> ItemOperationsTypeCheck.isRightOperandInExpression(usage.tree()))).isPresent();
        }

        private static boolean isRightOperandInExpression(Tree tree) {
            Tree parent = tree.parent();
            if (parent instanceof InExpression) {
                return ((InExpression)parent).rightOperand() == tree;
            }
            return false;
        }

        @Override
        public String message(@Nullable String name, String missingMethod) {
            if (name != null) {
                return String.format("Fix this \"%s\" operation; Previous type checks suggest that \"%s\" does not have this method.", missingMethod, name);
            }
            return String.format("Fix this \"%s\" operation; Previous type checks suggest that this expression does not have this method.", missingMethod);
        }
    }

    private static class IncompatibleOperandsCheck
    extends IncompatibleOperands {
        private IncompatibleOperandsCheck() {
        }

        @Override
        public IncompatibleOperands.SpecialMethod resolveMethod(InferredType type, String method) {
            Symbol symbol = type.resolveDeclaredMember(method).orElse(null);
            boolean isUnresolved = !InferredTypes.containsDeclaredType((InferredType)type) || symbol == null && type.declaresMember(method);
            return new IncompatibleOperands.SpecialMethod(symbol, isUnresolved);
        }

        @Override
        public String message(Token operator) {
            return "Fix this \"" + operator.value() + "\" operation; Previous type checks suggest that operand has incompatible type.";
        }

        @Override
        public String message(Token operator, InferredType left, InferredType right) {
            String leftTypeName = InferredTypes.typeName((InferredType)left);
            String rightTypeName = InferredTypes.typeName((InferredType)right);
            String message = "Fix this \"" + operator.value() + "\" operation; Previous type checks suggest that operands have incompatible types";
            if (leftTypeName != null && rightTypeName != null) {
                message = message + " (" + leftTypeName + " and " + rightTypeName + ")";
            }
            return message + ".";
        }
    }

    private static class NonCallableCalledCheck
    extends NonCallableCalled {
        private NonCallableCalledCheck() {
        }

        @Override
        public boolean isNonCallableType(InferredType type) {
            return InferredTypes.containsDeclaredType((InferredType)type) && !type.declaresMember("__call__");
        }

        @Override
        public String message(InferredType calleeType, @Nullable String name) {
            if (name != null) {
                return String.format("Fix this call; Previous type checks suggest that \"%s\"%s is not callable.", name, NonCallableCalledCheck.addTypeName(calleeType));
            }
            return String.format("Fix this call; Previous type checks suggest that this expression%s is not callable.", NonCallableCalledCheck.addTypeName(calleeType));
        }
    }
}

