/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5720")
public class InstanceMethodSelfAsFirstCheck
extends PythonSubscriptionCheck {
    private static final List<String> ALLOWED_NAMES = Arrays.asList("self", "_");
    private static final List<String> ALLOWED_NAMES_IN_METACLASSES = Arrays.asList("cls", "mcs");
    private static final List<String> EXCEPTIONS = Arrays.asList("__init_subclass__", "__class_getitem__", "__new__");
    private static final String DEFAULT_IGNORED_DECORATORS = "abstractmethod";
    private List<String> decoratorsToExclude;
    @RuleProperty(key="ignoredDecorators", description="Comma-separated list of decorators which will disable this rule.", defaultValue="abstractmethod")
    public String ignoredDecorators = "abstractmethod";

    private List<String> getExcludedDecorators() {
        if (this.decoratorsToExclude == null) {
            this.decoratorsToExclude = new ArrayList<String>();
            this.decoratorsToExclude.add("staticmethod");
            this.decoratorsToExclude.add("classmethod");
            this.decoratorsToExclude.addAll(Arrays.asList(this.ignoredDecorators.split(",")));
        }
        return this.decoratorsToExclude;
    }

    private boolean isNonInstanceMethodDecorator(Decorator decorator) {
        String fqn = decorator.name().names().stream().map(Name::name).collect(Collectors.joining("."));
        return this.getExcludedDecorators().stream().anyMatch(fqn::contains);
    }

    private static boolean isExceptionalUsageInClassBody(Usage usage, ClassDef parentClass) {
        if (usage.kind() != Usage.Kind.FUNC_DECLARATION) {
            Tree ancestor = TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF});
            return InstanceMethodSelfAsFirstCheck.isUsedAsDecorator(ancestor, usage.tree()) || parentClass.equals(ancestor);
        }
        return false;
    }

    private static boolean isUsedAsDecorator(@Nullable Tree tree, Tree usageTree) {
        if (tree instanceof FunctionDef) {
            return ((FunctionDef)tree).decorators().stream().flatMap(decorator -> decorator.name().names().stream()).anyMatch(name -> name.equals(usageTree));
        }
        return false;
    }

    private boolean isRelevantMethod(ClassDef classDef, ClassSymbol classSymbol, FunctionDef functionDef) {
        if (EXCEPTIONS.contains(functionDef.name().name())) {
            return false;
        }
        if (functionDef.decorators().stream().anyMatch(this::isNonInstanceMethodDecorator)) {
            return false;
        }
        FunctionSymbol functionSymbol = TreeUtils.getFunctionSymbolFromDef((FunctionDef)functionDef);
        if (functionSymbol == null || functionSymbol.usages().stream().anyMatch(usage -> InstanceMethodSelfAsFirstCheck.isExceptionalUsageInClassBody(usage, classDef))) {
            return false;
        }
        return !classSymbol.isOrExtends("zope.interface.Interface");
    }

    private static boolean isValidExceptionForCls(FunctionDef functionDef, String name, boolean mightBeMetaclass) {
        return ALLOWED_NAMES_IN_METACLASSES.contains(name) && (mightBeMetaclass || !functionDef.decorators().isEmpty());
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            ClassSymbol classSymbol = TreeUtils.getClassSymbolFromDef((ClassDef)classDef);
            if (classSymbol == null || TreeUtils.firstAncestorOfKind((Tree)classDef, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CLASSDEF}) != null) {
                return;
            }
            boolean mightBeMetaclass = !classDef.decorators().isEmpty() || classSymbol.isOrExtends("type") || classSymbol.isOrExtends("typing.Protocol") || classSymbol.hasUnresolvedTypeHierarchy();
            TreeUtils.topLevelFunctionDefs((ClassDef)classDef).forEach(functionDef -> {
                List parameters = TreeUtils.positionalParameters((FunctionDef)functionDef);
                if (parameters.isEmpty()) {
                    return;
                }
                Parameter first = (Parameter)parameters.get(0);
                if (first.starToken() != null) {
                    return;
                }
                Optional.ofNullable(first.name()).map(Name::name).ifPresent(name -> {
                    if (!ALLOWED_NAMES.contains(name) && this.isRelevantMethod(classDef, classSymbol, (FunctionDef)functionDef) && !InstanceMethodSelfAsFirstCheck.isValidExceptionForCls(functionDef, name, mightBeMetaclass)) {
                        ctx.addIssue((Tree)first, String.format("Rename \"%s\" to \"self\" or add the missing \"self\" parameter.", name));
                    }
                });
            });
        });
    }
}

