/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1763")
public class AfterJumpStatementCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            FileInput fileInput = (FileInput)ctx.syntaxNode();
            AfterJumpStatementCheck.checkCfg(ControlFlowGraph.build((FileInput)fileInput, (PythonFile)ctx.pythonFile()), ctx, fileInput.statements());
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            AfterJumpStatementCheck.checkCfg(ControlFlowGraph.build((FunctionDef)functionDef, (PythonFile)ctx.pythonFile()), ctx, functionDef.body());
        });
    }

    private static void checkCfg(@Nullable ControlFlowGraph cfg, SubscriptionContext ctx, @Nullable StatementList body) {
        if (cfg == null || body == null) {
            return;
        }
        TryStatementVisitor tryStatementVisitor = new TryStatementVisitor();
        body.accept((TreeVisitor)tryStatementVisitor);
        if (tryStatementVisitor.hasTryStatementContainingJump) {
            return;
        }
        for (CfgBlock cfgBlock : cfg.blocks()) {
            if (!cfgBlock.predecessors().isEmpty() || cfgBlock.equals(cfg.start()) || cfgBlock.elements().isEmpty()) continue;
            Tree firstElement = (Tree)cfgBlock.elements().get(0);
            Tree lastElement = (Tree)cfgBlock.elements().get(cfgBlock.elements().size() - 1);
            PythonCheck.PreciseIssue issue = ctx.addIssue(firstElement.firstToken(), lastElement.lastToken(), "Delete this unreachable code or refactor the code to make it reachable.");
            cfg.blocks().stream().filter(block -> cfgBlock.equals(block.syntacticSuccessor())).map(block -> (Tree)block.elements().get(block.elements().size() - 1)).forEach(jumpStatement -> issue.secondary(jumpStatement, "Statement exiting the current code block."));
        }
    }

    private static class TryStatementVisitor
    extends BaseTreeVisitor {
        boolean hasTryStatementContainingJump = false;

        private TryStatementVisitor() {
        }

        public void visitFunctionDef(FunctionDef functionDef) {
        }

        public void visitTryStatement(TryStatement tryStatement) {
            if (!this.hasTryStatementContainingJump) {
                this.hasTryStatementContainingJump = TreeUtils.hasDescendant((Tree)tryStatement, tree -> tree.is(new Tree.Kind[]{Tree.Kind.BREAK_STMT, Tree.Kind.CONTINUE_STMT, Tree.Kind.RETURN_STMT}));
            }
        }
    }
}

