/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.function.Consumer;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S2711")
public class ReturnYieldOutsideFunctionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this use of \"%s\".";
    public static final String CHECK_KEY = "S2711";
    private static final Consumer<SubscriptionContext> SUBSCRIPTION_CONTEXT_CONSUMER = ctx -> {
        Statement returnStatement = (Statement)ctx.syntaxNode();
        for (Tree currentParent = returnStatement.parent(); currentParent != null; currentParent = currentParent.parent()) {
            if (currentParent.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
                return;
            }
            if (!currentParent.is(new Tree.Kind[]{Tree.Kind.CLASSDEF})) continue;
            ctx.addIssue((Tree)returnStatement, String.format(MESSAGE, returnStatement.firstToken().value()));
            return;
        }
        ctx.addIssue((Tree)returnStatement, String.format(MESSAGE, returnStatement.firstToken().value()));
    };

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.YIELD_STMT, SUBSCRIPTION_CONTEXT_CONSUMER);
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_STMT, SUBSCRIPTION_CONTEXT_CONSUMER);
    }
}

