/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.FunctionDefImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1172")
public class UnusedFunctionParameterCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove the unused function parameter \"%s\".";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> UnusedFunctionParameterCheck.checkFunctionParameter(ctx, (FunctionDef)ctx.syntaxNode()));
    }

    private static void checkFunctionParameter(SubscriptionContext ctx, FunctionDef functionDef) {
        if (UnusedFunctionParameterCheck.isException(functionDef)) {
            return;
        }
        functionDef.localVariables().stream().filter(symbol -> !"self".equals(symbol.name())).map(Symbol::usages).filter(usages -> usages.size() == 1 && ((Usage)usages.get(0)).tree().parent().is(new Tree.Kind[]{Tree.Kind.PARAMETER})).map(usages -> (Parameter)((Usage)usages.get(0)).tree().parent()).forEach(param -> ctx.addIssue((Tree)param, String.format(MESSAGE, param.name().name())));
    }

    private static boolean isException(FunctionDef functionDef) {
        FunctionSymbol functionSymbol = ((FunctionDefImpl)functionDef).functionSymbol();
        return CheckUtils.containsCallToLocalsFunction((Tree)functionDef) || SymbolUtils.canBeAnOverridingMethod((FunctionSymbol)functionSymbol) || UnusedFunctionParameterCheck.isInterfaceMethod(functionDef) || UnusedFunctionParameterCheck.isNotImplemented(functionDef) || !functionDef.decorators().isEmpty() || UnusedFunctionParameterCheck.isSpecialMethod(functionDef) || UnusedFunctionParameterCheck.hasNonCallUsages(functionSymbol);
    }

    private static boolean isInterfaceMethod(FunctionDef functionDef) {
        return functionDef.body().statements().stream().allMatch(statement -> statement.is(new Tree.Kind[]{Tree.Kind.PASS_STMT, Tree.Kind.RAISE_STMT}) || statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STMT}) && UnusedFunctionParameterCheck.isStringExpressionOrEllipsis((ExpressionStatement)statement));
    }

    private static boolean isNotImplemented(FunctionDef functionDef) {
        List statements = functionDef.body().statements();
        if (statements.size() != 1) {
            return false;
        }
        if (!((Statement)statements.get(0)).is(new Tree.Kind[]{Tree.Kind.RETURN_STMT})) {
            return false;
        }
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        return returnStatement.expressions().stream().allMatch(retValue -> TreeUtils.getSymbolFromTree((Tree)retValue).filter(s -> "NotImplemented".equals(s.fullyQualifiedName())).isPresent());
    }

    private static boolean isStringExpressionOrEllipsis(ExpressionStatement stmt) {
        return stmt.expressions().stream().allMatch(expr -> expr.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.ELLIPSIS}));
    }

    private static boolean isSpecialMethod(FunctionDef functionDef) {
        String name = functionDef.name().name();
        return name.startsWith("__") && name.endsWith("__");
    }

    private static boolean hasNonCallUsages(@Nullable FunctionSymbol functionSymbol) {
        return Optional.ofNullable(functionSymbol).filter(fs -> fs.usages().stream().anyMatch(usage -> usage.kind() != Usage.Kind.FUNC_DECLARATION && !UnusedFunctionParameterCheck.isFunctionCall(usage))).isPresent();
    }

    private static boolean isFunctionCall(Usage usage) {
        if (usage.kind() != Usage.Kind.OTHER) {
            return false;
        }
        Tree tree = usage.tree();
        CallExpression callExpression = (CallExpression)TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CALL_EXPR});
        if (callExpression == null) {
            return false;
        }
        Expression callee = callExpression.callee();
        return callee == tree || TreeUtils.hasDescendant((Tree)callee, t -> t == tree);
    }
}

