/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.cfg.fixpoint.LiveVariablesAnalysis;
import org.sonar.python.checks.DeadStoreUtils;
import org.sonar.python.checks.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1854")
public class DeadStoreCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_TEMPLATE = "Remove this assignment to local variable '%s'; the value is never used.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (TreeUtils.hasDescendant((Tree)functionDef, tree -> tree.is(new Tree.Kind[]{Tree.Kind.TRY_STMT}))) {
                return;
            }
            ControlFlowGraph cfg = ControlFlowGraph.build((FunctionDef)functionDef, (PythonFile)ctx.pythonFile());
            if (cfg == null) {
                return;
            }
            LiveVariablesAnalysis lva = LiveVariablesAnalysis.analyze((ControlFlowGraph)cfg);
            cfg.blocks().forEach(block -> DeadStoreCheck.verifyBlock(ctx, block, lva.getLiveVariables(block), lva.getReadSymbols(), functionDef));
        });
    }

    private static void verifyBlock(SubscriptionContext ctx, CfgBlock block, LiveVariablesAnalysis.LiveVariables blockLiveVariables, Set<Symbol> readSymbols, FunctionDef functionDef) {
        DeadStoreUtils.findUnnecessaryAssignments(block, blockLiveVariables, functionDef).stream().filter(unnecessaryAssignment -> readSymbols.contains(unnecessaryAssignment.symbol)).filter(unnecessaryAssignment -> !DeadStoreCheck.isException(unnecessaryAssignment.symbol, unnecessaryAssignment.element, functionDef)).forEach(unnecessaryAssignment -> ctx.addIssue(unnecessaryAssignment.element, String.format(MESSAGE_TEMPLATE, unnecessaryAssignment.symbol.name())));
    }

    private static boolean isMultipleAssignement(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) && ((AssignmentStatement)element).lhsExpressions().stream().anyMatch(lhsExpression -> lhsExpression.expressions().size() > 1);
    }

    private static boolean isException(Symbol symbol, Tree element, FunctionDef functionDef) {
        return DeadStoreCheck.isUnderscoreVariable(symbol) || DeadStoreCheck.isAssignmentToFalsyOrTrueLiteral(element) || DeadStoreCheck.isFunctionDeclarationSymbol(symbol) || DeadStoreCheck.isLoopDeclarationSymbol(symbol, element) || DeadStoreCheck.isWithInstance(element) || DeadStoreUtils.isUsedInSubFunction(symbol, functionDef) || DeadStoreUtils.isParameter(element) || DeadStoreCheck.isMultipleAssignement(element) || DeadStoreCheck.isAnnotatedAssignmentWithoutRhs(element);
    }

    private static boolean isAnnotatedAssignmentWithoutRhs(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.ANNOTATED_ASSIGNMENT}) && ((AnnotatedAssignment)element).assignedValue() == null;
    }

    private static boolean isUnderscoreVariable(Symbol symbol) {
        return symbol.name().equals("_");
    }

    private static boolean isLoopDeclarationSymbol(Symbol symbol, Tree element) {
        return symbol.usages().stream().anyMatch(u -> u.kind() == Usage.Kind.LOOP_DECLARATION) && TreeUtils.firstAncestorOfKind((Tree)element, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FOR_STMT}) != null;
    }

    private static boolean isWithInstance(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.WITH_ITEM});
    }

    private static boolean isAssignmentToFalsyOrTrueLiteral(Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ANNOTATED_ASSIGNMENT})) {
            Expression assignedValue = element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) ? ((AssignmentStatement)element).assignedValue() : ((AnnotatedAssignment)element).assignedValue();
            return assignedValue != null && (Expressions.isFalsy(assignedValue) || assignedValue.is(new Tree.Kind[]{Tree.Kind.NAME}) && "True".equals(((Name)assignedValue).name()) || DeadStoreCheck.isNumericLiteralOne(assignedValue) || DeadStoreCheck.isMinusOne(assignedValue));
        }
        return false;
    }

    private static boolean isMinusOne(Expression assignedValue) {
        if (assignedValue.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS})) {
            Expression expression = ((UnaryExpression)assignedValue).expression();
            return DeadStoreCheck.isNumericLiteralOne(expression);
        }
        return false;
    }

    private static boolean isNumericLiteralOne(Expression expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && "1".equals(((NumericLiteral)expression).valueAsString());
    }

    private static boolean isFunctionDeclarationSymbol(Symbol symbol) {
        return symbol.usages().stream().anyMatch(u -> u.kind() == Usage.Kind.FUNC_DECLARATION);
    }
}

