/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S4144")
public class DuplicatedMethodImplementationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Update this function so that its implementation is not identical to %s on line %s.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            MethodVisitor methodVisitor = new MethodVisitor();
            classDef.body().accept((TreeVisitor)methodVisitor);
            for (int i = 1; i < methodVisitor.methods.size(); ++i) {
                DuplicatedMethodImplementationCheck.checkMethods(methodVisitor.methods.get(i), methodVisitor.methods, i, ctx);
            }
        });
    }

    private static void checkMethods(FunctionDef suspiciousMethod, List<FunctionDef> methods, int index, SubscriptionContext ctx) {
        StatementList suspiciousBody = suspiciousMethod.body();
        if (DuplicatedMethodImplementationCheck.isException(suspiciousMethod)) {
            return;
        }
        for (int j = 0; j < index; ++j) {
            FunctionDef originalMethod = methods.get(j);
            StatementList originalBody = originalMethod.body();
            if (!CheckUtils.areEquivalent((Tree)originalBody, (Tree)suspiciousBody)) continue;
            int line = originalMethod.name().firstToken().line();
            String message = String.format(MESSAGE, originalMethod.name().name(), line);
            ctx.addIssue((Tree)suspiciousMethod.name(), message).secondary((Tree)originalMethod.name(), "Original");
            break;
        }
    }

    private static boolean isException(FunctionDef suspiciousMethod) {
        int nbActualStatements;
        boolean hasDocString = suspiciousMethod.docstring() != null;
        StatementList suspiciousBody = suspiciousMethod.body();
        List statements = suspiciousBody.statements();
        int n = nbActualStatements = hasDocString ? statements.size() - 1 : statements.size();
        if (nbActualStatements == 0 || DuplicatedMethodImplementationCheck.isOnASingleLine(suspiciousBody, hasDocString)) {
            return true;
        }
        return nbActualStatements == 1 && ((Statement)statements.get(statements.size() - 1)).is(new Tree.Kind[]{Tree.Kind.RAISE_STMT});
    }

    private static boolean isOnASingleLine(StatementList statementList, boolean hasDocString) {
        int first = hasDocString ? 1 : 0;
        return ((Statement)statementList.statements().get(first)).firstToken().line() == ((Statement)statementList.statements().get(statementList.statements().size() - 1)).lastToken().line();
    }

    private static class MethodVisitor
    extends BaseTreeVisitor {
        List<FunctionDef> methods = new ArrayList<FunctionDef>();

        private MethodVisitor() {
        }

        public void visitClassDef(ClassDef classDef) {
        }

        public void visitFunctionDef(FunctionDef functionDef) {
            if (functionDef.isMethodDefinition()) {
                this.methods.add(functionDef);
            }
            super.visitFunctionDef(functionDef);
        }
    }
}

