/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.WhileStatement;

@Rule(key="S2836")
public class ElseAfterLoopsWithoutBreakCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Add a \"break\" statement or remove this \"else\" clause.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, ElseAfterLoopsWithoutBreakCheck::check);
        context.registerSyntaxNodeConsumer(Tree.Kind.WHILE_STMT, ElseAfterLoopsWithoutBreakCheck::check);
    }

    private static void check(SubscriptionContext subscriptionContext) {
        Tree loop = subscriptionContext.syntaxNode();
        ElseClause elseClause = ElseAfterLoopsWithoutBreakCheck.getElseClause(loop);
        if (elseClause != null && !ElseAfterLoopsWithoutBreakCheck.containsFreeBreak(ElseAfterLoopsWithoutBreakCheck.getLoopBody(loop))) {
            subscriptionContext.addIssue(elseClause.elseKeyword(), MESSAGE);
        }
    }

    private static ElseClause getElseClause(Tree loop) {
        return loop.is(new Tree.Kind[]{Tree.Kind.FOR_STMT}) ? ((ForStatement)loop).elseClause() : ((WhileStatement)loop).elseClause();
    }

    private static Tree getLoopBody(Tree loop) {
        return loop.is(new Tree.Kind[]{Tree.Kind.FOR_STMT}) ? ((ForStatement)loop).body() : ((WhileStatement)loop).body();
    }

    private static boolean containsFreeBreak(Tree t) {
        if (t.is(new Tree.Kind[]{Tree.Kind.BREAK_STMT})) {
            return true;
        }
        if (t.is(new Tree.Kind[]{Tree.Kind.WHILE_STMT, Tree.Kind.FOR_STMT})) {
            ElseClause elseClause = ElseAfterLoopsWithoutBreakCheck.getElseClause(t);
            if (elseClause != null) {
                return ElseAfterLoopsWithoutBreakCheck.containsFreeBreak((Tree)elseClause);
            }
            return false;
        }
        return t.children().stream().anyMatch(ElseAfterLoopsWithoutBreakCheck::containsFreeBreak);
    }
}

