/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S1451")
public class FileHeaderCopyrightCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT_HEADER_FORMAT = "";
    private static final String MESSAGE = "Add or update the header of this file.";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private Pattern searchPattern = null;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            if (this.isRegularExpression && this.searchPattern == null) {
                try {
                    this.searchPattern = Pattern.compile(this.headerFormat, 32);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("[" + ((Object)((Object)this)).getClass().getSimpleName() + "] Unable to compile the regular expression: " + this.headerFormat, e);
                }
            }
            String retrievedText = FileHeaderCopyrightCheck.getHeaderText(ctx);
            if (this.isRegularExpression) {
                this.checkRegularExpression((SubscriptionContext)ctx, retrievedText);
            } else if (!this.headerFormat.isEmpty() && !retrievedText.startsWith(this.headerFormat)) {
                ctx.addFileIssue(MESSAGE);
            }
        });
    }

    private static String getHeaderText(SubscriptionContext ctx) {
        StringLiteral tokenDoc = ((FileInput)ctx.syntaxNode()).docstring();
        if (tokenDoc != null && tokenDoc.firstToken().line() == 1) {
            return tokenDoc.firstToken().value();
        }
        return ctx.pythonFile().content();
    }

    private void checkRegularExpression(SubscriptionContext ctx, String fileContent) {
        Matcher matcher = this.searchPattern.matcher(fileContent);
        if (!matcher.find() || matcher.start() != 0) {
            ctx.addFileIssue(MESSAGE);
        }
    }
}

