/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5719")
public class InstanceAndClassMethodsAtLeastOnePositionalCheck
extends PythonSubscriptionCheck {
    private static final List<String> KNOWN_CLASS_METHODS = Arrays.asList("__new__", "__init_subclass__");

    private static boolean isUsageInClassBody(Usage usage, ClassDef classDef) {
        return usage.kind() != Usage.Kind.FUNC_DECLARATION && classDef.equals(TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF}));
    }

    private static void handleFunctionDef(SubscriptionContext ctx, ClassDef classDef, FunctionDef functionDef) {
        List parameters = TreeUtils.positionalParameters((FunctionDef)functionDef);
        if (!parameters.isEmpty()) {
            return;
        }
        ClassSymbol classSymbol = TreeUtils.getClassSymbolFromDef((ClassDef)classDef);
        if (classSymbol == null || classSymbol.isOrExtends("zope.interface.Interface")) {
            return;
        }
        FunctionSymbol functionSymbol = TreeUtils.getFunctionSymbolFromDef((FunctionDef)functionDef);
        if (functionSymbol == null || functionSymbol.usages().stream().anyMatch(usage -> InstanceAndClassMethodsAtLeastOnePositionalCheck.isUsageInClassBody(usage, classDef))) {
            return;
        }
        List decoratorNames = functionDef.decorators().stream().map(decorator -> TreeUtils.decoratorNameFromExpression((Expression)decorator.expression())).filter(Objects::nonNull).collect(Collectors.toList());
        if (decoratorNames.contains("staticmethod")) {
            return;
        }
        String name = functionSymbol.name();
        if (KNOWN_CLASS_METHODS.contains(name) || decoratorNames.contains("classmethod")) {
            ctx.addIssue(functionDef.defKeyword(), functionDef.rightPar(), "Add a class parameter");
        } else {
            ctx.addIssue(functionDef.defKeyword(), functionDef.rightPar(), "Add a \"self\" or class parameter");
        }
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> {
            ClassDef classDef = (ClassDef)ctx.syntaxNode();
            TreeUtils.topLevelFunctionDefs((ClassDef)classDef).forEach(functionDef -> InstanceAndClassMethodsAtLeastOnePositionalCheck.handleFunctionDef(ctx, classDef, functionDef));
        });
    }
}

