/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5659")
public class JwtVerificationCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Don't use a JWT token without verifying its signature.";
    private static final Set<String> PROCESS_JWT_NAMES = new HashSet<String>(Arrays.asList("python_jwt.process_jwt", "jwt.process_jwt"));
    private static final Set<String> VERIFY_JWT_NAMES = new HashSet<String>(Arrays.asList("python_jwt.verify_jwt", "jwt.verify_jwt"));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            Tree scriptOrFunction;
            CallExpression call = (CallExpression)ctx.syntaxNode();
            Symbol calleeSymbol = call.calleeSymbol();
            if (calleeSymbol == null) {
                return;
            }
            if ("jwt.decode".equals(calleeSymbol.fullyQualifiedName())) {
                RegularArgument verifyArg = TreeUtils.argumentByKeyword((String)"verify", (List)call.arguments());
                if (verifyArg != null && Expressions.isFalsy(verifyArg.expression())) {
                    ctx.addIssue((Tree)verifyArg, MESSAGE);
                }
            } else if (PROCESS_JWT_NAMES.contains(calleeSymbol.fullyQualifiedName()) && !TreeUtils.hasDescendant((Tree)(scriptOrFunction = TreeUtils.firstAncestorOfKind((Tree)call, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FILE_INPUT, Tree.Kind.FUNCDEF})), JwtVerificationCheck::isCallToVerifyJwt)) {
                ctx.addIssue((Tree)call, MESSAGE);
            }
        });
    }

    private static boolean isCallToVerifyJwt(Tree t) {
        if (t.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})) {
            Symbol symbol = ((CallExpression)t).calleeSymbol();
            return symbol != null && VERIFY_JWT_NAMES.contains(symbol.fullyQualifiedName());
        }
        return false;
    }
}

