/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.SetLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.AbstractDuplicateKeyCheck;

@Rule(key="S5781")
public class SetDuplicateKeyCheck
extends AbstractDuplicateKeyCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.SET_LITERAL, ctx -> {
            SetLiteral setLiteral = (SetLiteral)ctx.syntaxNode();
            HashSet<Integer> issueIndexes = new HashSet<Integer>();
            if (setLiteral.elements().size() > 100) {
                return;
            }
            for (int i = 0; i < setLiteral.elements().size(); ++i) {
                if (issueIndexes.contains(i)) continue;
                Expression key = (Expression)setLiteral.elements().get(i);
                List<Tree> duplicateKeys = this.findIdenticalKeys(i, setLiteral.elements(), issueIndexes);
                if (duplicateKeys.isEmpty()) continue;
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)key, "Change or remove duplicates of this key.");
                duplicateKeys.forEach(d -> issue.secondary(d, "Duplicate key"));
            }
        });
    }

    private List<Tree> findIdenticalKeys(int startIndex, List<Expression> elements, Set<Integer> issueIndexes) {
        Expression key = elements.get(startIndex);
        ArrayList<Tree> duplicates = new ArrayList<Tree>();
        for (int i = startIndex + 1; i < elements.size(); ++i) {
            Expression comparedKey = elements.get(i);
            if (!this.isSameKey(key, comparedKey)) continue;
            issueIndexes.add(i);
            duplicates.add((Tree)comparedKey);
        }
        return duplicates;
    }
}

