/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.SillyEquality;

@Rule(key="S2159")
public class SillyEqualityCheck
extends SillyEquality {
    @Override
    boolean areIdentityComparableOrNone(InferredType leftType, InferredType rightType) {
        return leftType.isIdentityComparableWith(rightType) || leftType.canOnlyBe("NoneType") || rightType.canOnlyBe("NoneType");
    }

    @Override
    public boolean canImplementEqOrNe(Expression expression) {
        InferredType type = expression.type();
        return type.canHaveMember("__eq__") || type.canHaveMember("__ne__");
    }

    @Override
    @CheckForNull
    String builtinTypeCategory(InferredType inferredType) {
        return BUILTINS_TYPE_CATEGORY.keySet().stream().filter(arg_0 -> ((InferredType)inferredType).canOnlyBe(arg_0)).map(BUILTINS_TYPE_CATEGORY::get).findFirst().orElse(null);
    }

    @Override
    String message(String result) {
        return String.format("Remove this equality check between incompatible types; it will always return %s.", result);
    }
}

