/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S905")
public class UselessStatementCheck
extends PythonSubscriptionCheck {
    private static final boolean DEFAULT_REPORT_ON_STRINGS = false;
    private static final String DEFAULT_IGNORED_OPERATORS = "<<,>>,|";
    @RuleProperty(key="reportOnStrings", description="Enable issues on string literals which are not assigned. Set this parameter to \"false\" if you use strings as comments.", defaultValue="false")
    public boolean reportOnStrings = false;
    @RuleProperty(key="ignoredOperators", description="Comma separated list of ignored operators", defaultValue="<<,>>,|")
    public String ignoredOperators = "<<,>>,|";
    List<String> ignoredOperatorsList;
    private static final List<Tree.Kind> regularKinds = Arrays.asList(Tree.Kind.NUMERIC_LITERAL, Tree.Kind.LIST_LITERAL, Tree.Kind.SET_LITERAL, Tree.Kind.DICTIONARY_LITERAL, Tree.Kind.NONE, Tree.Kind.LAMBDA);
    private static final List<Tree.Kind> binaryExpressionKinds = Arrays.asList(Tree.Kind.AND, Tree.Kind.OR, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.MULTIPLICATION, Tree.Kind.DIVISION, Tree.Kind.FLOOR_DIVISION, Tree.Kind.MODULO, Tree.Kind.MATRIX_MULTIPLICATION, Tree.Kind.SHIFT_EXPR, Tree.Kind.BITWISE_AND, Tree.Kind.BITWISE_OR, Tree.Kind.BITWISE_XOR, Tree.Kind.COMPARISON, Tree.Kind.POWER);
    private static final List<Tree.Kind> unaryExpressionKinds = Arrays.asList(Tree.Kind.UNARY_PLUS, Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.NOT);
    private static final String MESSAGE = "Remove or refactor this statement; it has no side effects.";

    private List<String> ignoredOperators() {
        if (this.ignoredOperatorsList == null) {
            this.ignoredOperatorsList = Stream.of(this.ignoredOperators.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return this.ignoredOperatorsList;
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_LITERAL, this::checkStringLiteral);
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, UselessStatementCheck::checkName);
        context.registerSyntaxNodeConsumer(Tree.Kind.QUALIFIED_EXPR, UselessStatementCheck::checkQualifiedExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.CONDITIONAL_EXPR, UselessStatementCheck::checkConditionalExpression);
        binaryExpressionKinds.forEach(b -> context.registerSyntaxNodeConsumer(b, this::checkBinaryExpression));
        unaryExpressionKinds.forEach(u -> context.registerSyntaxNodeConsumer(u, this::checkUnaryExpression));
        regularKinds.forEach(r -> context.registerSyntaxNodeConsumer(r, UselessStatementCheck::checkNode));
    }

    private static void checkNode(SubscriptionContext ctx) {
        Tree tree = ctx.syntaxNode();
        Tree tryParent = TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.TRY_STMT});
        if (tryParent != null) {
            return;
        }
        if (UselessStatementCheck.isBooleanExpressionWithCalls(tree)) {
            return;
        }
        Tree parent = tree.parent();
        if (parent == null || !parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STMT})) {
            return;
        }
        if (UselessStatementCheck.isWithinContextlibSuppress(tree)) {
            return;
        }
        ctx.addIssue(tree, MESSAGE);
    }

    private static boolean isWithinContextlibSuppress(Tree tree) {
        Tree withParent = TreeUtils.firstAncestorOfKind((Tree)tree, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.WITH_STMT});
        if (withParent != null) {
            WithStatement withStatement = (WithStatement)withParent;
            return withStatement.withItems().stream().map(WithItem::test).filter(item -> item.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR})).map(item -> ((CallExpression)item).calleeSymbol()).filter(Objects::nonNull).anyMatch(s -> "contextlib.suppress".equals(s.fullyQualifiedName()));
        }
        return false;
    }

    private static boolean isBooleanExpressionWithCalls(Tree tree) {
        return (tree.is(new Tree.Kind[]{Tree.Kind.AND}) || tree.is(new Tree.Kind[]{Tree.Kind.OR}) || tree.is(new Tree.Kind[]{Tree.Kind.NOT})) && TreeUtils.hasDescendant((Tree)tree, t -> t.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}));
    }

    public static void checkConditionalExpression(SubscriptionContext ctx) {
        ConditionalExpression conditionalExpression = (ConditionalExpression)ctx.syntaxNode();
        if (TreeUtils.hasDescendant((Tree)conditionalExpression, t -> t.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}))) {
            return;
        }
        UselessStatementCheck.checkNode(ctx);
    }

    private void checkStringLiteral(SubscriptionContext ctx) {
        StringLiteral stringLiteral = (StringLiteral)ctx.syntaxNode();
        if (!this.reportOnStrings || UselessStatementCheck.isDocString(stringLiteral)) {
            return;
        }
        UselessStatementCheck.checkNode(ctx);
    }

    private static void checkName(SubscriptionContext ctx) {
        ClassSymbol classSymbol;
        Name name = (Name)ctx.syntaxNode();
        Symbol symbol = name.symbol();
        if (symbol != null && symbol.is(new Symbol.Kind[]{Symbol.Kind.CLASS}) && (classSymbol = (ClassSymbol)symbol).canBeOrExtend("BaseException")) {
            return;
        }
        if (symbol != null && symbol.usages().stream().anyMatch(u -> u.kind().equals((Object)Usage.Kind.IMPORT)) && symbol.usages().size() == 2) {
            return;
        }
        UselessStatementCheck.checkNode(ctx);
    }

    private static void checkQualifiedExpression(SubscriptionContext ctx) {
        QualifiedExpression qualifiedExpression = (QualifiedExpression)ctx.syntaxNode();
        Symbol symbol = qualifiedExpression.symbol();
        if (symbol != null && symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION}) && ((FunctionSymbol)symbol).decorators().stream().noneMatch(d -> d.matches("property"))) {
            UselessStatementCheck.checkNode(ctx);
        }
    }

    private void checkBinaryExpression(SubscriptionContext ctx) {
        BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
        Token operator = binaryExpression.operator();
        if (this.ignoredOperators().contains(operator.value())) {
            return;
        }
        if (UselessStatementCheck.couldBePython2PrintStatement(binaryExpression)) {
            return;
        }
        UselessStatementCheck.checkNode(ctx);
    }

    private static boolean couldBePython2PrintStatement(BinaryExpression binaryExpression) {
        return TreeUtils.hasDescendant((Tree)binaryExpression, t -> t.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && ((CallExpression)t).callee().is(new Tree.Kind[]{Tree.Kind.NAME}) && ((Name)((CallExpression)t).callee()).name().equals("print"));
    }

    private void checkUnaryExpression(SubscriptionContext ctx) {
        UnaryExpression unaryExpression = (UnaryExpression)ctx.syntaxNode();
        Token operator = unaryExpression.operator();
        if (this.ignoredOperators().contains(operator.value())) {
            return;
        }
        UselessStatementCheck.checkNode(ctx);
    }

    private static boolean isDocString(StringLiteral stringLiteral) {
        Tree parent = TreeUtils.firstAncestorOfKind((Tree)stringLiteral, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FILE_INPUT, Tree.Kind.CLASSDEF, Tree.Kind.FUNCDEF});
        return Optional.ofNullable(parent).map(p -> p.is(new Tree.Kind[]{Tree.Kind.FILE_INPUT}) && stringLiteral.equals(((FileInput)p).docstring()) || p.is(new Tree.Kind[]{Tree.Kind.CLASSDEF}) && stringLiteral.equals(((ClassDef)p).docstring()) || p.is(new Tree.Kind[]{Tree.Kind.FUNCDEF}) && stringLiteral.equals(((FunctionDef)p).docstring())).orElse(false);
    }
}

