/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S117")
public class LocalVariableAndParameterNameConventionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Rename this %s \"%s\" to match the regular expression %s.";
    private static final String PARAMETER = "parameter";
    private static final String LOCAL_VAR = "local variable";
    private static final EnumSet<Usage.Kind> USAGES = EnumSet.of(Usage.Kind.PARAMETER, Usage.Kind.LOOP_DECLARATION, Usage.Kind.ASSIGNMENT_LHS);
    private static final String CONSTANT_PATTERN = "^[_A-Z][A-Z0-9_]*$";
    private static final String DEFAULT = "^[_a-z][a-z0-9_]*$";
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^[_a-z][a-z0-9_]*$")
    public String format = "^[_a-z][a-z0-9_]*$";
    private Pattern constantPattern;
    private Pattern pattern;

    public void initialize(SubscriptionCheck.Context context) {
        this.pattern = Pattern.compile(this.format);
        this.constantPattern = Pattern.compile(CONSTANT_PATTERN);
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef funcDef = (FunctionDef)ctx.syntaxNode();
            funcDef.localVariables().stream().sorted(Comparator.comparing(Symbol::name)).forEach(s -> this.checkName((Symbol)s, (SubscriptionContext)ctx));
        });
    }

    private void checkName(Symbol symbol, SubscriptionContext ctx) {
        String name = symbol.name();
        if (!this.pattern.matcher(name).matches()) {
            symbol.usages().stream().filter(usage -> USAGES.contains(usage.kind())).sorted(Comparator.comparingInt(u -> u.tree().firstToken().line())).limit(1L).forEach(usage -> this.raiseIssueForNameAndUsage(ctx, name, (Usage)usage));
        }
    }

    private void raiseIssueForNameAndUsage(SubscriptionContext ctx, String name, Usage usage) {
        String type = PARAMETER;
        Usage.Kind kind = usage.kind();
        if (kind == Usage.Kind.ASSIGNMENT_LHS) {
            type = LOCAL_VAR;
            if (this.constantPattern.matcher(name).matches()) {
                return;
            }
        } else if (kind == Usage.Kind.LOOP_DECLARATION) {
            type = LOCAL_VAR;
            if (name.length() <= 1) {
                return;
            }
        }
        ctx.addIssue(usage.tree(), String.format(MESSAGE, type, name, this.format));
    }
}

