/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.checks.Expressions;
import org.sonar.python.quickfix.IssueWithQuickFix;
import org.sonar.python.quickfix.PythonQuickFix;
import org.sonar.python.quickfix.PythonTextEdit;
import org.sonar.python.tree.IfStatementImpl;
import org.sonar.python.tree.TreeUtils;
import org.sonarsource.analyzer.commons.collections.ListUtils;

@Rule(key="S3923")
public class AllBranchesAreIdenticalCheck
extends PythonSubscriptionCheck {
    private static final List<ConditionalExpression> ignoreList = new ArrayList<ConditionalExpression>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> ignoreList.clear());
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> AllBranchesAreIdenticalCheck.handleIfStatement((IfStatement)ctx.syntaxNode(), ctx));
        context.registerSyntaxNodeConsumer(Tree.Kind.CONDITIONAL_EXPR, ctx -> AllBranchesAreIdenticalCheck.handleConditionalExpression((ConditionalExpression)ctx.syntaxNode(), ctx));
    }

    private static void handleIfStatement(IfStatement ifStmt, SubscriptionContext ctx) {
        if (ifStmt.elseBranch() == null) {
            return;
        }
        StatementList body = ifStmt.body();
        for (IfStatement elifBranch : ifStmt.elifBranches()) {
            StatementList elifBody = elifBranch.body();
            if (CheckUtils.areEquivalent((Tree)body, (Tree)elifBody)) continue;
            return;
        }
        if (!CheckUtils.areEquivalent((Tree)body, (Tree)ifStmt.elseBranch().body())) {
            return;
        }
        PythonCheck.PreciseIssue issue = ctx.addIssue(ifStmt.keyword(), "Remove this if statement or edit its code blocks so that they're not all the same.");
        issue.secondary(AllBranchesAreIdenticalCheck.issueLocation(ifStmt.body()));
        ifStmt.elifBranches().forEach(e -> issue.secondary(AllBranchesAreIdenticalCheck.issueLocation(e.body())));
        issue.secondary(AllBranchesAreIdenticalCheck.issueLocation(ifStmt.elseBranch().body()));
        AllBranchesAreIdenticalCheck.createQuickFix((IssueWithQuickFix)issue, (Tree)ifStmt, ifStmt.body().statements());
    }

    private static IssueLocation issueLocation(StatementList body) {
        List tokens = TreeUtils.nonWhitespaceTokens((Tree)body);
        return IssueLocation.preciseLocation((Token)((Token)tokens.get(0)), (Token)((Token)tokens.get(tokens.size() - 1)), null);
    }

    private static void handleConditionalExpression(ConditionalExpression conditionalExpression, SubscriptionContext ctx) {
        if (ignoreList.contains(conditionalExpression)) {
            return;
        }
        if (AllBranchesAreIdenticalCheck.areIdentical(conditionalExpression.trueExpression(), conditionalExpression.falseExpression())) {
            PythonCheck.PreciseIssue issue = ctx.addIssue(conditionalExpression.ifKeyword(), "This conditional expression returns the same value whether the condition is \"true\" or \"false\".");
            AllBranchesAreIdenticalCheck.addSecondaryLocations(issue, conditionalExpression.trueExpression());
            AllBranchesAreIdenticalCheck.addSecondaryLocations(issue, conditionalExpression.falseExpression());
            AllBranchesAreIdenticalCheck.createQuickFixConditional((IssueWithQuickFix)issue, (Tree)conditionalExpression);
        }
    }

    private static void addSecondaryLocations(PythonCheck.PreciseIssue issue, Expression expression) {
        Expression unwrappedExpression = Expressions.removeParentheses(expression);
        if (unwrappedExpression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR})) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)unwrappedExpression;
            ignoreList.add(conditionalExpression);
            AllBranchesAreIdenticalCheck.addSecondaryLocations(issue, conditionalExpression.trueExpression());
            AllBranchesAreIdenticalCheck.addSecondaryLocations(issue, conditionalExpression.falseExpression());
        } else {
            issue.secondary((Tree)unwrappedExpression, null);
        }
    }

    private static boolean areIdentical(Expression trueExpression, Expression falseExpression) {
        Expression unwrappedTrueExpression = AllBranchesAreIdenticalCheck.unwrapIdenticalExpressions(trueExpression);
        Expression unwrappedFalseExpression = AllBranchesAreIdenticalCheck.unwrapIdenticalExpressions(falseExpression);
        return CheckUtils.areEquivalent((Tree)unwrappedTrueExpression, (Tree)unwrappedFalseExpression);
    }

    private static Expression unwrapIdenticalExpressions(Expression expression) {
        boolean identicalExpressions;
        Expression unwrappedExpression = Expressions.removeParentheses(expression);
        if (unwrappedExpression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR}) && (identicalExpressions = AllBranchesAreIdenticalCheck.areIdentical(((ConditionalExpression)unwrappedExpression).trueExpression(), ((ConditionalExpression)unwrappedExpression).falseExpression()))) {
            while (unwrappedExpression.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPR})) {
                unwrappedExpression = Expressions.removeParentheses(((ConditionalExpression)unwrappedExpression).trueExpression());
            }
        }
        return unwrappedExpression;
    }

    private static void createQuickFixConditional(IssueWithQuickFix issue, Tree tree) {
        List children = tree.children();
        Token lastTokenOfFirst = ((Tree)children.get(0)).lastToken();
        Token lastTokenOfConditional = ((Tree)children.get(children.size() - 1)).lastToken();
        PythonTextEdit edit = new PythonTextEdit("", lastTokenOfFirst.line(), lastTokenOfFirst.column(), lastTokenOfConditional.line(), lastTokenOfConditional.column());
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)"Remove the if statement").addTextEdit(new PythonTextEdit[]{edit}).build();
        issue.addQuickFix(quickFix);
    }

    private static void createQuickFix(IssueWithQuickFix issue, Tree tree, List<Statement> statements) {
        IfStatementImpl ifStatement = (IfStatementImpl)tree;
        Token firstBodyToken = statements.get(0).firstToken();
        Token keyword = ifStatement.keyword();
        Statement lastStatement = (Statement)ListUtils.getLast(statements);
        int firstLine = firstBodyToken.line();
        int lastLine = lastStatement.lastToken().line();
        Optional<ElseClause> elseBranch = Optional.ofNullable(ifStatement.elseBranch());
        Optional<Integer> lineElseBranch = elseBranch.map(Tree::firstToken).map(Token::line);
        if (lastStatement.lastToken().column() == 0) {
            --lastLine;
        }
        PythonQuickFix.Builder quickFixBuilder = PythonQuickFix.newQuickFix((String)"Remove the if statement");
        quickFixBuilder.addTextEdit(new PythonTextEdit[]{new PythonTextEdit("", keyword.line(), keyword.column(), firstBodyToken.line(), firstBodyToken.column())});
        for (int line = firstLine + 1; line <= lastLine; ++line) {
            quickFixBuilder.addTextEdit(new PythonTextEdit[]{AllBranchesAreIdenticalCheck.editIndentAtLine(line)});
        }
        elseBranch.ifPresent(branch -> quickFixBuilder.addTextEdit(new PythonTextEdit[]{PythonTextEdit.remove((Tree)branch)}));
        if (ifStatement.elifBranches().isEmpty()) {
            lineElseBranch.ifPresent(lineElse -> quickFixBuilder.addTextEdit(new PythonTextEdit[]{AllBranchesAreIdenticalCheck.editIndentAtLine(lineElse)}));
        }
        for (IfStatement branch2 : ifStatement.elifBranches()) {
            int lineElifBranch = branch2.firstToken().line();
            quickFixBuilder.addTextEdit(new PythonTextEdit[]{PythonTextEdit.remove((Tree)branch2)}).addTextEdit(new PythonTextEdit[]{AllBranchesAreIdenticalCheck.editIndentAtLine(lineElifBranch)});
        }
        issue.addQuickFix(quickFixBuilder.build());
    }

    private static PythonTextEdit editIndentAtLine(int line) {
        return new PythonTextEdit("", line, 0, line, 4);
    }
}

