/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5886")
public class FunctionReturnTypeCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Return a value of type \"%s\" instead of \"%s\" or update function \"%s\" type hint.";
    private static final List<String> ITERABLE_TYPES = Arrays.asList("typing.Generator", "typing.Iterator", "typing.Iterable");
    private static final List<String> ASYNC_ITERABLE_TYPES = Arrays.asList("typing.AsyncGenerator", "typing.AsyncIterator", "typing.AsyncIterable");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            Symbol symbol = functionDef.name().symbol();
            if (symbol == null || !symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})) {
                return;
            }
            FunctionSymbolImpl functionSymbol = (FunctionSymbolImpl)symbol;
            InferredType declaredReturnType = functionSymbol.declaredReturnType();
            if (declaredReturnType == InferredTypes.anyType()) {
                return;
            }
            ReturnTypeVisitor returnTypeVisitor = new ReturnTypeVisitor(declaredReturnType);
            functionDef.body().accept((TreeVisitor)returnTypeVisitor);
            FunctionReturnTypeCheck.raiseIssues(ctx, functionDef, declaredReturnType, returnTypeVisitor);
        });
    }

    private static void raiseIssues(SubscriptionContext ctx, FunctionDef functionDef, InferredType declaredReturnType, ReturnTypeVisitor returnTypeVisitor) {
        String returnTypeName;
        String functionName;
        block4: {
            String recommendedSuperType;
            block6: {
                boolean isAsyncFunction;
                block5: {
                    functionName = functionDef.name().name();
                    returnTypeName = InferredTypes.typeName((InferredType)declaredReturnType);
                    if (returnTypeVisitor.yieldStatements.isEmpty()) break block4;
                    isAsyncFunction = functionDef.asyncKeyword() != null;
                    recommendedSuperType = isAsyncFunction ? "typing.AsyncGenerator" : "typing.Generator";
                    if (ITERABLE_TYPES.stream().anyMatch(arg_0 -> ((InferredType)declaredReturnType).mustBeOrExtend(arg_0))) break block5;
                    if (!ASYNC_ITERABLE_TYPES.stream().anyMatch(arg_0 -> ((InferredType)declaredReturnType).mustBeOrExtend(arg_0))) break block6;
                }
                if (FunctionReturnTypeCheck.isMixedUpAnnotation(isAsyncFunction, declaredReturnType)) {
                    returnTypeVisitor.yieldStatements.forEach(y -> {
                        PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)y, String.format("Annotate function \"%s\" with \"%s\" or one of its supertypes.", functionName, recommendedSuperType));
                        FunctionReturnTypeCheck.addSecondaries(issue, functionDef);
                    });
                }
                return;
            }
            returnTypeVisitor.yieldStatements.forEach(y -> {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)y, String.format("Remove this yield statement or annotate function \"%s\" with \"%s\" or one of its supertypes.", functionName, recommendedSuperType));
                FunctionReturnTypeCheck.addSecondaries(issue, functionDef);
            });
        }
        returnTypeVisitor.invalidReturnStatements.forEach(i -> {
            PythonCheck.PreciseIssue issue = i.expressions().size() > 1 ? ctx.addIssue((Tree)i, String.format(MESSAGE, returnTypeName, "tuple", functionName)) : (i.expressions().size() == 1 && InferredTypes.typeName((InferredType)((Expression)i.expressions().get(0)).type()) != null ? ctx.addIssue((Tree)i.expressions().get(0), String.format(MESSAGE, returnTypeName, InferredTypes.typeName((InferredType)((Expression)i.expressions().get(0)).type()), functionName)) : ctx.addIssue((Tree)i, String.format("Return a value of type \"%s\" or update function \"%s\" type hint.", returnTypeName, functionName)));
            FunctionReturnTypeCheck.addSecondaries(issue, functionDef);
        });
    }

    private static boolean isMixedUpAnnotation(boolean isAsyncFunction, InferredType declaredReturnType) {
        return isAsyncFunction ? ITERABLE_TYPES.stream().anyMatch(arg_0 -> ((InferredType)declaredReturnType).mustBeOrExtend(arg_0)) : ASYNC_ITERABLE_TYPES.stream().anyMatch(arg_0 -> ((InferredType)declaredReturnType).mustBeOrExtend(arg_0));
    }

    private static void addSecondaries(PythonCheck.PreciseIssue issue, FunctionDef functionDef) {
        issue.secondary((Tree)functionDef.name(), "Function definition.");
        TypeAnnotation returnTypeAnnotation = functionDef.returnTypeAnnotation();
        if (returnTypeAnnotation != null) {
            issue.secondary((Tree)returnTypeAnnotation.expression(), "Type hint.");
        }
    }

    private static class ReturnTypeVisitor
    extends BaseTreeVisitor {
        InferredType returnType;
        List<YieldStatement> yieldStatements = new ArrayList<YieldStatement>();
        List<ReturnStatement> invalidReturnStatements = new ArrayList<ReturnStatement>();

        ReturnTypeVisitor(InferredType returnType) {
            this.returnType = returnType;
        }

        public void visitFunctionDef(FunctionDef functionDef) {
        }

        public void visitReturnStatement(ReturnStatement returnStatement) {
            List expressions = returnStatement.expressions();
            if (expressions.isEmpty()) {
                if (!InferredTypes.NONE.isCompatibleWith(this.returnType)) {
                    this.invalidReturnStatements.add(returnStatement);
                }
            } else if (!returnStatement.commas().isEmpty()) {
                if (!InferredTypes.TUPLE.isCompatibleWith(this.returnType)) {
                    this.invalidReturnStatements.add(returnStatement);
                }
            } else {
                Expression expression = (Expression)expressions.get(0);
                InferredType inferredType = expression.type();
                if (this.returnType.mustBeOrExtend("typing.TypedDict")) {
                    return;
                }
                if (!InferredTypes.containsDeclaredType((InferredType)inferredType) && !inferredType.isCompatibleWith(this.returnType)) {
                    this.invalidReturnStatements.add(returnStatement);
                }
            }
            super.visitReturnStatement(returnStatement);
        }

        public void visitYieldStatement(YieldStatement yieldStatement) {
            this.yieldStatements.add(yieldStatement);
            super.visitYieldStatement(yieldStatement);
        }
    }
}

