/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.InferredTypes;

public abstract class NonCallableCalled
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Expression callee = callExpression.callee();
            InferredType calleeType = callee.type();
            if (this.isNonCallableType(calleeType)) {
                String name = TreeUtils.nameFromExpression((Expression)callee);
                PythonCheck.PreciseIssue preciseIssue = ctx.addIssue((Tree)callee, this.message(calleeType, name));
                LocationInFile location = InferredTypes.typeClassLocation((InferredType)calleeType);
                if (location != null) {
                    preciseIssue.secondary(location, "Definition.");
                }
            }
        });
    }

    protected static String addTypeName(InferredType type) {
        String typeName = InferredTypes.typeName((InferredType)type);
        if (typeName != null) {
            return " has type " + typeName + " and it";
        }
        return "";
    }

    public abstract boolean isNonCallableType(InferredType var1);

    public abstract String message(InferredType var1, @Nullable String var2);
}

