/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;

public abstract class AbstractS3BucketCheck
extends PythonSubscriptionCheck {
    protected static final String S3_BUCKET_FQN = "aws_cdk.aws_s3.Bucket";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::visitNode);
    }

    protected void visitNode(SubscriptionContext ctx) {
        CallExpression node = (CallExpression)ctx.syntaxNode();
        Optional.ofNullable(node.calleeSymbol()).map(Symbol::fullyQualifiedName).filter(S3_BUCKET_FQN::equals).ifPresent(s -> this.visitBucketConstructor(ctx, node));
    }

    abstract void visitBucketConstructor(SubscriptionContext var1, CallExpression var2);

    protected static Optional<ArgumentTrace> getArgument(SubscriptionContext ctx, CallExpression callExpression, String argumentName) {
        return callExpression.arguments().stream().map(RegularArgument.class::cast).filter(regularArgument -> regularArgument.keywordArgument() != null).filter(regularArgument -> argumentName.equals(regularArgument.keywordArgument().name())).map(regularArgument -> ArgumentTrace.build(ctx, regularArgument)).findAny();
    }

    protected static boolean isFalse(Expression expression) {
        return Optional.ofNullable(expression.firstToken()).map(Token::value).filter("False"::equals).isPresent();
    }

    static class ArgumentTrace {
        private static final String TAIL_MESSAGE = "Propagated setting.";
        private final SubscriptionContext ctx;
        private final List<Expression> trace;

        ArgumentTrace(SubscriptionContext ctx, List<Expression> trace) {
            this.ctx = ctx;
            this.trace = Collections.unmodifiableList(trace);
        }

        private static ArgumentTrace build(SubscriptionContext ctx, RegularArgument argument) {
            ArrayList<Expression> trace = new ArrayList<Expression>();
            ArgumentTrace.buildTrace(argument.expression(), trace);
            return new ArgumentTrace(ctx, trace);
        }

        private static void buildTrace(Expression expression, List<Expression> trace) {
            Expression singleAssignedValue;
            trace.add(expression);
            if (expression.is(new Tree.Kind[]{Tree.Kind.NAME}) && (singleAssignedValue = Expressions.singleAssignedValue((Name)expression)) != null && !trace.contains(singleAssignedValue)) {
                ArgumentTrace.buildTrace(singleAssignedValue, trace);
            }
        }

        public void addIssue(String primaryMessage) {
            PythonCheck.PreciseIssue issue = this.ctx.addIssue(this.trace.get(0).parent(), primaryMessage);
            this.trace.stream().skip(1L).forEach(expression -> issue.secondary(expression.parent(), TAIL_MESSAGE));
        }

        public void addIssueIf(Predicate<Expression> predicate, String primaryMessage) {
            if (this.hasExpression(predicate)) {
                this.addIssue(primaryMessage);
            }
        }

        public boolean hasExpression(Predicate<Expression> predicate) {
            return this.trace.stream().anyMatch(predicate);
        }

        public List<Expression> trace() {
            return this.trace;
        }
    }
}

