/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractS3BucketCheck;

@Rule(key="S6252")
public class S3BucketVersioningCheck
extends AbstractS3BucketCheck {
    public static final String MESSAGE = "Make sure an unversioned S3 bucket is safe here.";
    public static final String MESSAGE_OMITTING = "Omitting the \"versioned\" argument disables S3 bucket versioning. Make sure it is safe here.";

    @Override
    void visitBucketConstructor(SubscriptionContext ctx, CallExpression bucket) {
        Optional<AbstractS3BucketCheck.ArgumentTrace> version = S3BucketVersioningCheck.getArgument(ctx, bucket, "versioned");
        if (version.isPresent()) {
            version.get().addIssueIf(AbstractS3BucketCheck::isFalse, MESSAGE);
        } else {
            ctx.addIssue((Tree)bucket.callee(), MESSAGE_OMITTING);
        }
    }
}

