/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractS3BucketCheck;
import org.sonar.python.tree.QualifiedExpressionImpl;

@Rule(key="S6245")
public class S3BucketServerEncryptionCheck
extends AbstractS3BucketCheck {
    private static final String S3_BUCKET_UNENCRYPTED_FQN = "aws_cdk.aws_s3.BucketEncryption.UNENCRYPTED";
    public static final String MESSAGE = "Objects in the bucket are not encrypted. Make sure it is safe here.";
    public static final String OMITTING_MESSAGE = "Omitting 'encryption' disables server-side encryption. Make sure it is safe here.";

    @Override
    void visitBucketConstructor(SubscriptionContext ctx, CallExpression bucket) {
        Optional<AbstractS3BucketCheck.ArgumentTrace> optEncryptionType = S3BucketServerEncryptionCheck.getArgument(ctx, bucket, "encryption");
        if (optEncryptionType.isPresent()) {
            optEncryptionType.ifPresent(argumentTrace -> argumentTrace.addIssueIf(S3BucketServerEncryptionCheck::isUnencrypted, MESSAGE));
        } else {
            Optional<AbstractS3BucketCheck.ArgumentTrace> optEncryptionKey = S3BucketServerEncryptionCheck.getArgument(ctx, bucket, "encryption_key");
            if (!optEncryptionKey.isPresent()) {
                ctx.addIssue((Tree)bucket.callee(), OMITTING_MESSAGE);
            }
        }
    }

    protected static boolean isUnencrypted(Expression expression) {
        return Optional.of(expression).filter(QualifiedExpression.class::isInstance).map(QualifiedExpressionImpl.class::cast).map(QualifiedExpression::symbol).map(Symbol::fullyQualifiedName).filter(S3_BUCKET_UNENCRYPTED_FQN::equals).isPresent();
    }
}

