/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.cfg.fixpoint.LiveVariablesAnalysis;
import org.sonar.python.checks.DeadStoreUtils;
import org.sonar.python.checks.Expressions;
import org.sonar.python.quickfix.IssueWithQuickFix;
import org.sonar.python.quickfix.PythonQuickFix;
import org.sonar.python.quickfix.PythonTextEdit;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1854")
public class DeadStoreCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_TEMPLATE = "Remove this assignment to local variable '%s'; the value is never used.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (TreeUtils.hasDescendant((Tree)functionDef, tree -> tree.is(new Tree.Kind[]{Tree.Kind.TRY_STMT}))) {
                return;
            }
            ControlFlowGraph cfg = ControlFlowGraph.build((FunctionDef)functionDef, (PythonFile)ctx.pythonFile());
            if (cfg == null) {
                return;
            }
            LiveVariablesAnalysis lva = LiveVariablesAnalysis.analyze((ControlFlowGraph)cfg);
            cfg.blocks().forEach(block -> DeadStoreCheck.verifyBlock(ctx, block, lva.getLiveVariables(block), lva.getReadSymbols(), functionDef));
        });
    }

    private static void verifyBlock(SubscriptionContext ctx, CfgBlock block, LiveVariablesAnalysis.LiveVariables blockLiveVariables, Set<Symbol> readSymbols, FunctionDef functionDef) {
        DeadStoreUtils.findUnnecessaryAssignments(block, blockLiveVariables, functionDef).stream().filter(unnecessaryAssignment -> readSymbols.contains(unnecessaryAssignment.symbol)).filter(unnecessaryAssignment -> !DeadStoreCheck.isException(unnecessaryAssignment.symbol, unnecessaryAssignment.element, functionDef)).forEach(unnecessaryAssignment -> {
            Tree element = unnecessaryAssignment.element;
            String message = String.format(MESSAGE_TEMPLATE, unnecessaryAssignment.symbol.name());
            IssueWithQuickFix issue = (IssueWithQuickFix)DeadStoreCheck.separatorTokenForIssue(element).map(separator -> ctx.addIssue(element.firstToken(), separator, message)).orElseGet(() -> ctx.addIssue(element, message));
            DeadStoreCheck.createQuickFix(issue, element);
        });
    }

    private static boolean isMultipleAssignement(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) && ((AssignmentStatement)element).lhsExpressions().stream().anyMatch(lhsExpression -> lhsExpression.expressions().size() > 1);
    }

    private static boolean isException(Symbol symbol, Tree element, FunctionDef functionDef) {
        return DeadStoreCheck.isUnderscoreVariable(symbol) || DeadStoreCheck.isAssignmentToFalsyOrTrueLiteral(element) || DeadStoreCheck.isFunctionDeclarationSymbol(symbol) || DeadStoreCheck.isLoopDeclarationSymbol(symbol, element) || DeadStoreCheck.isWithInstance(element) || DeadStoreUtils.isUsedInSubFunction(symbol, functionDef) || DeadStoreUtils.isParameter(element) || DeadStoreCheck.isMultipleAssignement(element) || DeadStoreCheck.isAnnotatedAssignmentWithoutRhs(element);
    }

    private static boolean isAnnotatedAssignmentWithoutRhs(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.ANNOTATED_ASSIGNMENT}) && ((AnnotatedAssignment)element).assignedValue() == null;
    }

    private static boolean isUnderscoreVariable(Symbol symbol) {
        return symbol.name().equals("_");
    }

    private static boolean isLoopDeclarationSymbol(Symbol symbol, Tree element) {
        return symbol.usages().stream().anyMatch(u -> u.kind() == Usage.Kind.LOOP_DECLARATION) && TreeUtils.firstAncestorOfKind((Tree)element, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FOR_STMT}) != null;
    }

    private static boolean isWithInstance(Tree element) {
        return element.is(new Tree.Kind[]{Tree.Kind.WITH_ITEM});
    }

    private static boolean isAssignmentToFalsyOrTrueLiteral(Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.ANNOTATED_ASSIGNMENT})) {
            Expression assignedValue = element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT}) ? ((AssignmentStatement)element).assignedValue() : ((AnnotatedAssignment)element).assignedValue();
            return assignedValue != null && (Expressions.isFalsy(assignedValue) || assignedValue.is(new Tree.Kind[]{Tree.Kind.NAME}) && "True".equals(((Name)assignedValue).name()) || DeadStoreCheck.isNumericLiteralOne(assignedValue) || DeadStoreCheck.isMinusOne(assignedValue));
        }
        return false;
    }

    private static boolean isMinusOne(Expression assignedValue) {
        if (assignedValue.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS})) {
            Expression expression = ((UnaryExpression)assignedValue).expression();
            return DeadStoreCheck.isNumericLiteralOne(expression);
        }
        return false;
    }

    private static boolean isNumericLiteralOne(Expression expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && "1".equals(((NumericLiteral)expression).valueAsString());
    }

    private static boolean isFunctionDeclarationSymbol(Symbol symbol) {
        return symbol.usages().stream().anyMatch(u -> u.kind() == Usage.Kind.FUNC_DECLARATION);
    }

    private static Optional<Token> separatorTokenForIssue(Tree element) {
        return DeadStoreCheck.separatorTokenOfElement(element).filter(sep -> !"\n".equals(sep.value()));
    }

    private static Optional<Token> separatorTokenOfElement(Tree element) {
        if (element.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.EXPRESSION_STMT})) {
            Token separator = ((Statement)element).separator();
            return Optional.ofNullable(separator);
        }
        return Optional.empty();
    }

    private static PythonTextEdit removeDeadStore(Tree currentTree) {
        Optional<Token> tokenSeparator = DeadStoreCheck.separatorTokenOfElement(currentTree);
        List childrenOfParent = currentTree.parent().children();
        if (childrenOfParent.size() == 1) {
            return PythonTextEdit.replace((Tree)currentTree, (String)"pass");
        }
        Token currentFirstToken = currentTree.firstToken();
        int indexOfCurrentTree = childrenOfParent.indexOf(currentTree);
        if (indexOfCurrentTree == childrenOfParent.size() - 1) {
            Tree previousTree = (Tree)childrenOfParent.get(indexOfCurrentTree - 1);
            Optional<Token> previousSep = DeadStoreCheck.separatorTokenOfElement(previousTree);
            Token previous = previousSep.orElse(previousTree.lastToken());
            currentFirstToken = tokenSeparator.orElse(currentTree.lastToken());
            return DeadStoreCheck.removeFromEndOfTillEndOf(previous, currentFirstToken);
        }
        int currentLine = currentTree.lastToken().line();
        int nextLine = ((Tree)childrenOfParent.get(indexOfCurrentTree + 1)).firstToken().line();
        if (nextLine > currentLine + 1) {
            Token next = tokenSeparator.orElse(currentTree.lastToken());
            return new PythonTextEdit("", currentFirstToken.line(), currentFirstToken.column(), next.line(), next.column() + next.value().length());
        }
        Token next = ((Tree)childrenOfParent.get(indexOfCurrentTree + 1)).firstToken();
        return new PythonTextEdit("", currentFirstToken.line(), currentFirstToken.column(), next.line(), next.column());
    }

    private static void createQuickFix(IssueWithQuickFix issue, Tree unnecessaryAssignment) {
        PythonTextEdit edit = DeadStoreCheck.removeDeadStore(unnecessaryAssignment);
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)"Remove the unused statement").addTextEdit(new PythonTextEdit[]{edit}).build();
        issue.addQuickFix(quickFix);
    }

    private static PythonTextEdit removeFromEndOfTillEndOf(Token first, Token last) {
        return new PythonTextEdit("", first.line(), first.column() + first.value().length(), last.line(), last.column() + last.value().length());
    }
}

