/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S1110")
public class UselessParenthesisCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1110";
    private static final String MESSAGE = "Remove those useless parentheses.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.PARENTHESIZED, ctx -> {
            ParenthesizedExpression parenthesized = (ParenthesizedExpression)ctx.syntaxNode();
            Expression expression = parenthesized.expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED}) || expression.is(new Tree.Kind[]{Tree.Kind.TUPLE}) || expression.is(new Tree.Kind[]{Tree.Kind.GENERATOR_EXPR})) {
                ctx.addIssue(parenthesized.leftParenthesis(), MESSAGE).secondary(parenthesized.rightParenthesis(), null);
            }
        });
    }
}

