/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.tree.TreeUtils;

public class CdkPredicate {
    private CdkPredicate() {
    }

    public static Predicate<Expression> isFalse() {
        return expression -> Optional.ofNullable(expression.firstToken()).map(Token::value).filter("False"::equals).isPresent();
    }

    public static Predicate<Expression> isNone() {
        return expression -> expression.is(new Tree.Kind[]{Tree.Kind.NONE});
    }

    public static Predicate<Expression> isFqn(String fqnValue) {
        return expression -> Optional.ofNullable(TreeUtils.fullyQualifiedNameFromExpression((Expression)expression)).filter(fqnValue::equals).isPresent();
    }

    public static Predicate<Expression> isFqnOf(Collection<String> fqnValues) {
        return expression -> Optional.ofNullable(TreeUtils.fullyQualifiedNameFromExpression((Expression)expression)).filter(fqnValues::contains).isPresent();
    }

    public static Predicate<Expression> isString(String expectedValue) {
        return expression -> CdkUtils.getString(expression).filter(expectedValue::equals).isPresent();
    }

    public static Predicate<Expression> startsWith(String expected) {
        return expression -> CdkUtils.getString(expression).filter(str -> str.toLowerCase(Locale.ROOT).startsWith(expected)).isPresent();
    }
}

