/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;
import org.sonar.python.checks.cdk.CdkPredicate;

public class CdkUtils {
    private CdkUtils() {
    }

    public static Optional<Integer> getInt(Expression expression) {
        try {
            return Optional.of((int)((NumericLiteral)expression).valueAsLong());
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> getString(Expression expression) {
        try {
            return Optional.of(((StringLiteral)expression).trimmedQuotesValue());
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public static Optional<CallExpression> getCall(Expression expression, String fqn) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && CdkPredicate.isFqn(fqn).test(expression)) {
            return Optional.of((CallExpression)expression);
        }
        return Optional.empty();
    }

    protected static Optional<ExpressionFlow> getArgument(SubscriptionContext ctx, CallExpression callExpression, String argumentName) {
        return callExpression.arguments().stream().map(RegularArgument.class::cast).filter(regularArgument -> regularArgument.keywordArgument() != null).filter(regularArgument -> argumentName.equals(regularArgument.keywordArgument().name())).map(regularArgument -> ExpressionFlow.build(ctx, regularArgument.expression())).findAny();
    }

    public static Optional<ResolvedKeyValuePair> getKeyValuePair(SubscriptionContext ctx, DictionaryLiteralElement element) {
        return element.is(new Tree.Kind[]{Tree.Kind.KEY_VALUE_PAIR}) ? Optional.of(ResolvedKeyValuePair.build(ctx, (KeyValuePair)element)) : Optional.empty();
    }

    static class ResolvedKeyValuePair {
        final ExpressionFlow key;
        final ExpressionFlow value;

        private ResolvedKeyValuePair(ExpressionFlow key, ExpressionFlow value) {
            this.key = key;
            this.value = value;
        }

        static ResolvedKeyValuePair build(SubscriptionContext ctx, KeyValuePair pair) {
            return new ResolvedKeyValuePair(ExpressionFlow.build(ctx, pair.key()), ExpressionFlow.build(ctx, pair.value()));
        }
    }

    static class ExpressionFlow {
        private static final String TAIL_MESSAGE = "Propagated setting.";
        private final SubscriptionContext ctx;
        private final Deque<Expression> locations;

        private ExpressionFlow(SubscriptionContext ctx, Deque<Expression> locations) {
            this.ctx = ctx;
            this.locations = locations;
        }

        protected static ExpressionFlow build(SubscriptionContext ctx, Expression expression) {
            LinkedList<Expression> locations = new LinkedList<Expression>();
            ExpressionFlow.resolveLocations(expression, locations);
            return new ExpressionFlow(ctx, locations);
        }

        static void resolveLocations(Expression expression, Deque<Expression> locations) {
            Expression singleAssignedValue;
            locations.add(expression);
            if (expression.is(new Tree.Kind[]{Tree.Kind.NAME}) && (singleAssignedValue = Expressions.singleAssignedValue((Name)expression)) != null && !locations.contains(singleAssignedValue)) {
                ExpressionFlow.resolveLocations(singleAssignedValue, locations);
            }
        }

        public void addIssue(String primaryMessage) {
            PythonCheck.PreciseIssue issue = this.ctx.addIssue(this.locations.getFirst().parent(), primaryMessage);
            this.locations.stream().skip(1L).forEach(expression -> issue.secondary(expression.parent(), TAIL_MESSAGE));
        }

        public void addIssueIf(Predicate<Expression> predicate, String primaryMessage) {
            if (this.hasExpression(predicate)) {
                this.addIssue(primaryMessage);
            }
        }

        public void addIssueIf(Predicate<Expression> predicate, String primaryMessage, CallExpression call) {
            if (this.hasExpression(predicate)) {
                this.ctx.addIssue((Tree)call.callee(), primaryMessage);
            }
        }

        public boolean hasExpression(Predicate<Expression> predicate) {
            return this.locations.stream().anyMatch(predicate);
        }

        public Optional<Expression> getExpression(Predicate<Expression> predicate) {
            return this.locations.stream().filter(predicate).findFirst();
        }

        public Deque<Expression> locations() {
            return this.locations;
        }
    }
}

