/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6303")
public class DisabledRDSEncryptionCheck
extends AbstractCdkResourceCheck {
    private static final String UNENCRYPTED_MESSAGE = "Make sure that using unencrypted databases is safe here.";
    private static final String ARG_ENCRYPTED = "storage_encrypted";
    private static final String ARG_ENCRYPTION_KEY = "storage_encryption_key";
    private static final String DB_OMITTING_MESSAGE = "Omitting \"storage_encrypted\" and \"storage_encryption_key\" disables RDS encryption. Make sure it is safe here.";
    private static final String CFNDB_OMITTING_MESSAGE = "Omitting \"storage_encrypted\" disables RDS encryption. Make sure it is safe here.";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqns(List.of("aws_cdk.aws_rds.DatabaseCluster", "aws_cdk.aws_rds.DatabaseInstance", "aws_cdk.aws_rds.CfnDBCluster"), this::checkDatabaseArguments);
        this.checkFqn("aws_cdk.aws_rds.CfnDBInstance", (subscriptionContext, callExpression) -> {
            if (!this.isEngineAurora((SubscriptionContext)subscriptionContext, (CallExpression)callExpression)) {
                this.checkCfnDatabaseArguments((SubscriptionContext)subscriptionContext, (CallExpression)callExpression);
            }
        });
    }

    protected void checkDatabaseArguments(SubscriptionContext ctx, CallExpression resourceConstructor) {
        Optional<CdkUtils.ExpressionFlow> argEncrypted = CdkUtils.getArgument(ctx, resourceConstructor, ARG_ENCRYPTED);
        Optional<CdkUtils.ExpressionFlow> argEncryptionKey = CdkUtils.getArgument(ctx, resourceConstructor, ARG_ENCRYPTION_KEY);
        if (argEncrypted.isEmpty() && argEncryptionKey.isEmpty()) {
            ctx.addIssue((Tree)resourceConstructor.callee(), DB_OMITTING_MESSAGE);
        } else if (argEncrypted.isEmpty()) {
            argEncryptionKey.get().addIssueIf(CdkPredicate.isNone(), UNENCRYPTED_MESSAGE);
        } else if (argEncryptionKey.isEmpty()) {
            argEncrypted.get().addIssueIf(CdkPredicate.isFalse(), UNENCRYPTED_MESSAGE);
        } else if (argEncryptionKey.get().hasExpression(CdkPredicate.isNone()) && argEncrypted.get().hasExpression(CdkPredicate.isFalse())) {
            argEncrypted.get().addIssue(UNENCRYPTED_MESSAGE);
        }
    }

    protected void checkCfnDatabaseArguments(SubscriptionContext ctx, CallExpression resourceConstructor) {
        CdkUtils.getArgument(ctx, resourceConstructor, ARG_ENCRYPTED).ifPresentOrElse(flow -> flow.addIssueIf(CdkPredicate.isFalse(), UNENCRYPTED_MESSAGE), () -> ctx.addIssue((Tree)resourceConstructor.callee(), CFNDB_OMITTING_MESSAGE));
    }

    protected boolean isEngineAurora(SubscriptionContext ctx, CallExpression resourceConstructor) {
        return CdkUtils.getArgument(ctx, resourceConstructor, "engine").filter(flow -> flow.hasExpression(CdkPredicate.startsWith("aurora"))).isPresent();
    }
}

