/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.function.BiConsumer;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractS3BucketCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6245")
public class S3BucketServerEncryptionCheck
extends AbstractS3BucketCheck {
    private static final String S3_BUCKET_UNENCRYPTED_FQN = "aws_cdk.aws_s3.BucketEncryption.UNENCRYPTED";
    public static final String MESSAGE = "Objects in the bucket are not encrypted. Make sure it is safe here.";
    public static final String OMITTING_MESSAGE = "Omitting 'encryption' disables server-side encryption. Make sure it is safe here.";

    @Override
    BiConsumer<SubscriptionContext, CallExpression> visitBucketConstructor() {
        return (ctx, bucket) -> CdkUtils.getArgument(ctx, bucket, "encryption").ifPresentOrElse(encryption -> encryption.addIssueIf(CdkPredicate.isFqn(S3_BUCKET_UNENCRYPTED_FQN), MESSAGE), () -> S3BucketServerEncryptionCheck.checkEncryptionKey(ctx, bucket));
    }

    private static void checkEncryptionKey(SubscriptionContext ctx, CallExpression bucket) {
        if (CdkUtils.getArgument(ctx, bucket, "encryption_key").isEmpty()) {
            ctx.addIssue((Tree)bucket.callee(), OMITTING_MESSAGE);
        }
    }
}

