/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6275")
public class UnencryptedEbsVolumeCheck
extends AbstractCdkResourceCheck {
    private static final String PRIMARY_MESSAGE = "Make sure that using unencrypted volumes is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"encrypted\" disables volumes encryption. Make sure it is safe here.";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_ec2.Volume", (ctx, volume) -> CdkUtils.getArgument(ctx, volume, "encrypted").ifPresentOrElse(flow -> flow.addIssueIf(CdkPredicate.isFalse(), PRIMARY_MESSAGE), () -> ctx.addIssue((Tree)volume.callee(), OMITTING_MESSAGE)));
    }
}

