/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

public class WeakSSLProtocolCheckPart
extends AbstractCdkResourceCheck {
    private static final String ENFORCE_MESSAGE = "Change this code to enforce TLS 1.2 or above.";
    private static final String OMITTING_MESSAGE = "Omitting \"tls_security_policy\" enables a deprecated version of TLS. Set it to enforce TLS 1.2 or above.";
    private static final String APIGATEWAY_FQN = "aws_cdk.aws_apigateway.";
    private static final String APIGATEWAYV2_FQN = "aws_cdk.aws_apigatewayv2.";
    private static final String OPENSEARCH_FQN = "aws_cdk.aws_opensearchservice.";
    private static final String ELASTICSEARCH_FQN = "aws_cdk.aws_elasticsearch.";
    private static final String TLS_SECURITY_POLICY = "tls_security_policy";
    private static final String SENSITIVE_TLS_SECURITY_POLICY = "Policy-Min-TLS-1-0-2019-07";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_apigateway.DomainName", WeakSSLProtocolCheckPart.checkDomainName(CdkPredicate.isFqn("aws_cdk.aws_apigateway.SecurityPolicy.TLS_1_0")));
        this.checkFqn("aws_cdk.aws_apigatewayv2.DomainName", WeakSSLProtocolCheckPart.checkDomainName(CdkPredicate.isFqn("aws_cdk.aws_apigatewayv2.SecurityPolicy.TLS_1_0")));
        this.checkFqn("aws_cdk.aws_apigateway.CfnDomainName", WeakSSLProtocolCheckPart.checkDomainName(CdkPredicate.isString("TLS_1_0")));
        this.checkFqn("aws_cdk.aws_opensearchservice.Domain", WeakSSLProtocolCheckPart.checkDomain(CdkPredicate.isFqn("aws_cdk.aws_opensearchservice.TLSSecurityPolicy.TLS_1_0")));
        this.checkFqn("aws_cdk.aws_elasticsearch.Domain", WeakSSLProtocolCheckPart.checkDomain(CdkPredicate.isFqn("aws_cdk.aws_elasticsearch.TLSSecurityPolicy.TLS_1_0")));
        this.checkFqn("aws_cdk.aws_opensearchservice.CfnDomain", WeakSSLProtocolCheckPart.checkCfnDomain("aws_cdk.aws_opensearchservice.CfnDomain.DomainEndpointOptionsProperty"));
        this.checkFqn("aws_cdk.aws_elasticsearch.CfnDomain", WeakSSLProtocolCheckPart.checkCfnDomain("aws_cdk.aws_elasticsearch.CfnDomain.DomainEndpointOptionsProperty"));
    }

    private static BiConsumer<SubscriptionContext, CallExpression> checkDomainName(Predicate<Expression> predicateIssue) {
        return (ctx, callExpression) -> CdkUtils.getArgument(ctx, callExpression, "security_policy").ifPresent(flow -> flow.addIssueIf(predicateIssue, ENFORCE_MESSAGE));
    }

    private static BiConsumer<SubscriptionContext, CallExpression> checkDomain(Predicate<Expression> predicateIssue) {
        return (ctx, callExpression) -> CdkUtils.getArgument(ctx, callExpression, TLS_SECURITY_POLICY).ifPresentOrElse(flow -> flow.addIssueIf(predicateIssue, ENFORCE_MESSAGE), () -> ctx.addIssue((Tree)callExpression.callee(), OMITTING_MESSAGE));
    }

    private static BiConsumer<SubscriptionContext, CallExpression> checkCfnDomain(String domainOptionName) {
        return (ctx, callExpression) -> CdkUtils.getArgument(ctx, callExpression, "domain_endpoint_options").ifPresentOrElse(flow -> flow.addIssueIf(WeakSSLProtocolCheckPart.isSensitiveOptionObj(ctx, domainOptionName).or(WeakSSLProtocolCheckPart.isSensitiveDictionaryTls(ctx)), ENFORCE_MESSAGE), () -> ctx.addIssue((Tree)callExpression.callee(), OMITTING_MESSAGE));
    }

    private static Predicate<Expression> isSensitiveOptionObj(SubscriptionContext ctx, String fqn) {
        return expression -> CdkUtils.getCall(expression, fqn).map(call -> CdkUtils.getArgument(ctx, call, TLS_SECURITY_POLICY)).stream().anyMatch(policy -> policy.isEmpty() || policy.filter(flow -> flow.hasExpression(CdkPredicate.isString(SENSITIVE_TLS_SECURITY_POLICY))).isPresent());
    }

    private static Predicate<Expression> isSensitiveDictionaryTls(SubscriptionContext ctx) {
        return expression -> Optional.of(expression).filter(expr -> expr.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})).map(DictionaryLiteral.class::cast).filter(WeakSSLProtocolCheckPart.hasDictionaryKeyValue(ctx, TLS_SECURITY_POLICY, CdkPredicate.isString(SENSITIVE_TLS_SECURITY_POLICY))).isPresent();
    }

    private static Predicate<DictionaryLiteral> hasDictionaryKeyValue(SubscriptionContext ctx, String key, Predicate<Expression> expected) {
        return dict -> dict.elements().stream().map(e -> CdkUtils.getKeyValuePair(ctx, e)).flatMap(Optional::stream).filter(pair -> pair.key.hasExpression(CdkPredicate.isString(key))).allMatch(pair -> pair.value.hasExpression(expected));
    }
}

