/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;

@Rule(key="S112")
public class GenericExceptionRaisedCheck
extends PythonSubscriptionCheck {
    private static final Set<String> GENERIC_EXCEPTION_NAMES = new HashSet<String>(Arrays.asList("Exception", "BaseException"));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> {
            RaiseStatement raise = (RaiseStatement)ctx.syntaxNode();
            List expressions = raise.expressions();
            if (expressions.isEmpty()) {
                return;
            }
            Expression expression = (Expression)expressions.get(0);
            InferredType type = expression.type();
            if (GENERIC_EXCEPTION_NAMES.stream().anyMatch(arg_0 -> ((InferredType)type).canOnlyBe(arg_0)) || GenericExceptionRaisedCheck.isGenericExceptionClass(expression)) {
                ctx.addIssue((Tree)expression, "Replace this generic exception class with a more specific one.");
            }
        });
    }

    private static boolean isGenericExceptionClass(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME})) {
            Symbol symbol = ((Name)expression).symbol();
            return symbol != null && GENERIC_EXCEPTION_NAMES.contains(symbol.fullyQualifiedName());
        }
        return false;
    }
}

