/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

public class CdkIamUtils {
    private CdkIamUtils() {
    }

    public static boolean hasNotAllowEffect(@Nullable CdkUtils.ExpressionFlow effect) {
        if (effect == null) {
            return false;
        }
        return !effect.hasExpression(CdkPredicate.isFqn("aws_cdk.aws_iam.Effect.ALLOW").or(CdkIamUtils.isJsonString("allow")));
    }

    private static Predicate<Expression> isJsonString(String expectedValue) {
        return expression -> CdkUtils.getString(expression).filter(expectedValue::equalsIgnoreCase).isPresent();
    }

    private static Optional<CdkUtils.ExpressionFlow> getWildcardInList(SubscriptionContext ctx, ListLiteral list) {
        return CdkUtils.getListElements(ctx, list).stream().filter(expr -> expr.hasExpression(CdkPredicate.isString("*"))).findFirst();
    }

    public static Optional<CdkUtils.ExpressionFlow> getWildcard(SubscriptionContext ctx, CdkUtils.ExpressionFlow json) {
        if (json.hasExpression(CdkPredicate.isString("*"))) {
            return Optional.of(json);
        }
        return CdkUtils.getList(json).flatMap(list -> CdkIamUtils.getWildcardInList(ctx, list));
    }

    public static Optional<DictionaryLiteral> getObjectFromJson(SubscriptionContext ctx, CallExpression call) {
        return CdkUtils.getArgument(ctx, call, "obj", 0).flatMap(CdkUtils::getDictionary);
    }

    public static List<DictionaryLiteral> getPolicyStatements(SubscriptionContext ctx, DictionaryLiteral json) {
        return CdkUtils.getDictionaryPair(ctx, json, "Statement").map(pair -> pair.value).flatMap(CdkUtils::getList).map(list -> CdkUtils.getDictionaryInList(ctx, list)).orElse(Collections.emptyList());
    }
}

