/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6270")
public class IamPolicyPublicAccessCheck
extends AbstractCdkResourceCheck {
    private static final String ISSUE_MESSAGE = "Make sure granting public access is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect.";
    private static final String IAM_EFFECT_ALLOW = "aws_cdk.aws_iam.Effect.ALLOW";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_iam.PolicyStatement", IamPolicyPublicAccessCheck::checkPolicyStatementConstructor);
        this.checkFqn("aws_cdk.aws_iam.PolicyStatement.from_json", IamPolicyPublicAccessCheck::checkPolicyStatementJson);
        this.checkFqn("aws_cdk.aws_iam.PolicyDocument.from_json", IamPolicyPublicAccessCheck::checkPolicyDocumentJson);
    }

    private static void checkPolicyStatementConstructor(SubscriptionContext subscriptionContext, CallExpression callExpression) {
        Optional<CdkUtils.ExpressionFlow> effect = CdkUtils.getArgument(subscriptionContext, callExpression, "effect");
        CdkUtils.getArgument(subscriptionContext, callExpression, "principals").flatMap(CdkUtils::getListExpression).ifPresent(principals -> {
            Optional allowSetting = effect.flatMap(expressionFlow -> expressionFlow.getExpression(CdkPredicate.isFqn(IAM_EFFECT_ALLOW)));
            if (effect.isEmpty() || allowSetting.isPresent()) {
                CdkUtils.getListElements(subscriptionContext, principals).forEach(principalElement -> IamPolicyPublicAccessCheck.raiseIssueIf(principalElement, IamPolicyPublicAccessCheck.isSensitivePrincipal(), allowSetting.orElse(null)));
            }
        });
    }

    private static void checkPolicyStatementJson(SubscriptionContext subscriptionContext, CallExpression callExpression) {
        if (callExpression.arguments().isEmpty()) {
            return;
        }
        CdkUtils.getArgument(subscriptionContext, callExpression, "obj", 0).flatMap(CdkUtils::getDictionary).ifPresent(dictionaryLiteral -> IamPolicyPublicAccessCheck.checkJsonEntry(subscriptionContext, dictionaryLiteral));
    }

    private static void checkPolicyDocumentJson(SubscriptionContext subscriptionContext, CallExpression callExpression) {
        Optional dictionaryLiteral = CdkUtils.getArgument(subscriptionContext, callExpression, "obj", 0).flatMap(CdkUtils::getDictionary);
        if (dictionaryLiteral.isEmpty()) {
            return;
        }
        Optional statement = CdkUtils.getDictionaryPair(subscriptionContext, (DictionaryLiteral)dictionaryLiteral.get(), "Statement").flatMap(resolvedKeyValuePair -> CdkUtils.getList(resolvedKeyValuePair.value));
        if (statement.isEmpty()) {
            return;
        }
        CdkUtils.getListElements(subscriptionContext, (ListLiteral)statement.get()).stream().map(CdkUtils::getDictionary).flatMap(Optional::stream).forEach(innerDict -> IamPolicyPublicAccessCheck.checkJsonEntry(subscriptionContext, innerDict));
    }

    private static void checkJsonEntry(SubscriptionContext subscriptionContext, DictionaryLiteral dictionaryLiteral) {
        List<CdkUtils.ResolvedKeyValuePair> resolvedKeyValuePairs = CdkUtils.resolveDictionary(subscriptionContext, dictionaryLiteral);
        Optional<CdkUtils.ResolvedKeyValuePair> effect = CdkUtils.getDictionaryPair(resolvedKeyValuePairs, "Effect");
        Expression effectSetting = effect.flatMap(expressionFlow -> expressionFlow.value.getExpression(CdkPredicate.isString("Allow"))).orElse(null);
        if (effect.isPresent() && effectSetting == null) {
            return;
        }
        CdkUtils.getDictionaryPair(resolvedKeyValuePairs, "Principal").map(pair -> pair.value).ifPresent(principal -> {
            IamPolicyPublicAccessCheck.raiseIssueIf(principal, CdkPredicate.isString("*"), effectSetting);
            CdkUtils.getDictionary(principal).flatMap(innerDict -> CdkUtils.getDictionaryPair(subscriptionContext, innerDict, "AWS")).ifPresent(aws -> {
                IamPolicyPublicAccessCheck.raiseIssueIf(aws.value, CdkPredicate.isString("*"), effectSetting);
                CdkUtils.getListExpression(aws.value).ifPresent(listLiteral -> CdkUtils.getListElements(subscriptionContext, listLiteral).forEach(principalElement -> IamPolicyPublicAccessCheck.raiseIssueIf(principalElement, CdkPredicate.isString("*"), effectSetting)));
            });
        });
    }

    private static Predicate<Expression> isSensitivePrincipal() {
        return CdkPredicate.isFqnOf(List.of("aws_cdk.aws_iam.StarPrincipal", "aws_cdk.aws_iam.AnyPrincipal")).or(IamPolicyPublicAccessCheck.isSensitiveArnPrincipal());
    }

    private static Predicate<Expression> isSensitiveArnPrincipal() {
        return expression -> CdkUtils.getCall(expression, "aws_cdk.aws_iam.ArnPrincipal").map(callExpression -> TreeUtils.nthArgumentOrKeyword((int)0, (String)"arn", (List)callExpression.arguments())).map(RegularArgument::expression).filter(CdkPredicate.isString("*")).isPresent();
    }

    private static void raiseIssueIf(CdkUtils.ExpressionFlow expressionFlow, Predicate<Expression> predicate, @Nullable Expression effect) {
        if (effect != null) {
            expressionFlow.addIssueIf(predicate, ISSUE_MESSAGE, IssueLocation.preciseLocation((Tree)effect, (String)SECONDARY_MESSAGE));
        } else {
            expressionFlow.addIssueIf(predicate, ISSUE_MESSAGE, new IssueLocation[0]);
        }
    }
}

