/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkIamUtils;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6302")
public class PrivilegePolicyCheck
extends AbstractCdkResourceCheck {
    private static final String MESSAGE = "Make sure granting all privileges is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_iam.PolicyStatement", (ctx, call) -> {
            CdkUtils.ExpressionFlow effect = CdkUtils.getArgument(ctx, call, "effect").orElse(null);
            if (CdkIamUtils.hasNotAllowEffect(effect)) {
                return;
            }
            CdkUtils.getArgument(ctx, call, "actions").flatMap(resources -> CdkIamUtils.getWildcard(ctx, resources)).ifPresent(wildcard -> PrivilegePolicyCheck.reportWildcardActionAndEffect(ctx, wildcard, effect));
        });
        this.checkFqn("aws_cdk.aws_iam.PolicyStatement.from_json", (ctx, call) -> CdkIamUtils.getObjectFromJson(ctx, call).ifPresent(json -> PrivilegePolicyCheck.checkPolicyStatement(ctx, json)));
        this.checkFqn("aws_cdk.aws_iam.PolicyDocument.from_json", (ctx, call) -> CdkIamUtils.getObjectFromJson(ctx, call).ifPresent(json -> CdkIamUtils.getPolicyStatements(ctx, json).forEach(statement -> PrivilegePolicyCheck.checkPolicyStatement(ctx, statement))));
    }

    private static void checkPolicyStatement(SubscriptionContext ctx, DictionaryLiteral statement) {
        List<CdkUtils.ResolvedKeyValuePair> pairs = CdkUtils.resolveDictionary(ctx, statement);
        CdkUtils.ExpressionFlow effect = CdkUtils.getDictionaryValue(pairs, "Effect").orElse(null);
        if (CdkIamUtils.hasNotAllowEffect(effect)) {
            return;
        }
        CdkUtils.getDictionaryValue(pairs, "Action").flatMap(action -> CdkIamUtils.getWildcard(ctx, action)).ifPresent(wildcard -> PrivilegePolicyCheck.reportWildcardActionAndEffect(ctx, wildcard, effect));
    }

    private static void reportWildcardActionAndEffect(SubscriptionContext ctx, CdkUtils.ExpressionFlow wildcard, CdkUtils.ExpressionFlow effect) {
        PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)wildcard.getLast(), MESSAGE);
        if (effect != null) {
            issue.secondary(effect.asSecondaryLocation(SECONDARY_MESSAGE));
        }
    }
}

