/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkIamUtils;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6304")
public class ResourceAccessPolicyCheck
extends AbstractCdkResourceCheck {
    private static final String MESSAGE = "Make sure granting access to all resources is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_iam.PolicyStatement", (ctx, call) -> {
            CdkUtils.ExpressionFlow effect = CdkUtils.getArgument(ctx, call, "effect").orElse(null);
            if (ResourceAccessPolicyCheck.hasOnlyKmsActions(ctx, call) || CdkIamUtils.hasNotAllowEffect(effect)) {
                return;
            }
            CdkUtils.getArgument(ctx, call, "resources").flatMap(resources -> CdkIamUtils.getWildcard(ctx, resources)).ifPresent(wildcard -> ResourceAccessPolicyCheck.reportWildcardResourceAndEffect(ctx, wildcard, effect));
        });
        this.checkFqn("aws_cdk.aws_iam.PolicyStatement.from_json", (ctx, call) -> CdkIamUtils.getObjectFromJson(ctx, call).ifPresent(statement -> ResourceAccessPolicyCheck.checkPolicyStatement(ctx, statement)));
        this.checkFqn("aws_cdk.aws_iam.PolicyDocument.from_json", (ctx, call) -> CdkIamUtils.getObjectFromJson(ctx, call).ifPresent(json -> CdkIamUtils.getPolicyStatements(ctx, json).forEach(statement -> ResourceAccessPolicyCheck.checkPolicyStatement(ctx, statement))));
    }

    private static void checkPolicyStatement(SubscriptionContext ctx, DictionaryLiteral statement) {
        List<CdkUtils.ResolvedKeyValuePair> pairs = CdkUtils.resolveDictionary(ctx, statement);
        CdkUtils.ExpressionFlow effect = CdkUtils.getDictionaryValue(pairs, "Effect").orElse(null);
        if (ResourceAccessPolicyCheck.hasOnlyKmsActions(ctx, pairs) || CdkIamUtils.hasNotAllowEffect(effect)) {
            return;
        }
        CdkUtils.getDictionaryValue(pairs, "Resource").flatMap(action -> CdkIamUtils.getWildcard(ctx, action)).ifPresent(wildcard -> ResourceAccessPolicyCheck.reportWildcardResourceAndEffect(ctx, wildcard, effect));
    }

    private static boolean hasOnlyKmsActions(SubscriptionContext ctx, CallExpression call) {
        return CdkUtils.getArgument(ctx, call, "actions").flatMap(CdkUtils::getList).filter(actions -> ResourceAccessPolicyCheck.hasOnlyKmsActions(ctx, actions)).isPresent();
    }

    private static boolean hasOnlyKmsActions(SubscriptionContext ctx, List<CdkUtils.ResolvedKeyValuePair> json) {
        return CdkUtils.getDictionaryValue(json, "Action").flatMap(CdkUtils::getList).filter(actions -> ResourceAccessPolicyCheck.hasOnlyKmsActions(ctx, actions)).isPresent();
    }

    private static boolean hasOnlyKmsActions(SubscriptionContext ctx, ListLiteral actions) {
        return CdkUtils.getListElements(ctx, actions).stream().allMatch(flow -> flow.hasExpression(CdkPredicate.startsWith("kms:")));
    }

    private static void reportWildcardResourceAndEffect(SubscriptionContext ctx, CdkUtils.ExpressionFlow wildcard, CdkUtils.ExpressionFlow effect) {
        PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)wildcard.getLast(), MESSAGE);
        if (effect != null) {
            issue.secondary(effect.asSecondaryLocation(SECONDARY_MESSAGE));
        }
    }
}

