/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Trivia;
import org.sonar.python.quickfix.IssueWithQuickFix;
import org.sonar.python.quickfix.PythonQuickFix;
import org.sonar.python.quickfix.PythonTextEdit;

@Rule(key="S139")
public class TrailingCommentCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^#\\s*+([^\\s]++|fmt.*|type.*)$";
    private static final String MESSAGE = "Move this trailing comment on the previous empty line.";
    @RuleProperty(key="legalTrailingCommentPattern", description="Pattern for text of trailing comments that are allowed. By default, Mypy and Black pragma comments as well as comments containing only one word.", defaultValue="^#\\s*+([^\\s]++|fmt.*|type.*)$")
    public String legalCommentPattern = "^#\\s*+([^\\s]++|fmt.*|type.*)$";
    private int previousTokenLine;
    private List<String> lines;

    public void initialize(SubscriptionCheck.Context context) {
        Pattern pattern = Pattern.compile(this.legalCommentPattern);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.previousTokenLine = -1;
            this.lines = null;
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.TOKEN, ctx -> {
            Token token = (Token)ctx.syntaxNode();
            for (Trivia trivia : token.trivia()) {
                String comment;
                Token commentToken = trivia.token();
                if (this.previousTokenLine != commentToken.line() || pattern.matcher(comment = commentToken.value()).matches()) continue;
                IssueWithQuickFix issue = (IssueWithQuickFix)ctx.addIssue(commentToken, MESSAGE);
                String line = this.getLines((SubscriptionContext)ctx).get(commentToken.line() - 1);
                TrailingCommentCheck.addQuickFix(issue, commentToken, line);
            }
            this.previousTokenLine = token.line();
        });
    }

    private static void addQuickFix(IssueWithQuickFix issue, Token commentToken, String line) {
        String indent = TrailingCommentCheck.calculateIndent(line);
        PythonTextEdit insertComment = PythonTextEdit.insertAtPosition((int)commentToken.line(), (int)0, (String)(indent + commentToken.value() + "\n"));
        int startColumnRemove = TrailingCommentCheck.calculateStartColumnToRemove(commentToken, line);
        PythonTextEdit removeTrailingComment = PythonTextEdit.removeRange((int)commentToken.line(), (int)startColumnRemove, (int)commentToken.line(), (int)line.length());
        PythonQuickFix fix = PythonQuickFix.newQuickFix((String)MESSAGE, (PythonTextEdit[])new PythonTextEdit[]{removeTrailingComment, insertComment});
        issue.addQuickFix(fix);
    }

    private static String calculateIndent(String line) {
        String lineWithoutIndent = line.stripLeading();
        int column = line.indexOf(lineWithoutIndent);
        return " ".repeat(column);
    }

    private List<String> getLines(SubscriptionContext ctx) {
        if (this.lines == null) {
            this.lines = ctx.pythonFile().content().lines().collect(Collectors.toList());
        }
        return this.lines;
    }

    private static int calculateStartColumnToRemove(Token commentToken, String line) {
        return line.substring(0, commentToken.column()).stripTrailing().length();
    }
}

