/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.checks.Expressions;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.tree.TreeUtils;

public class CdkUtils {
    private CdkUtils() {
    }

    public static Optional<Integer> getInt(Expression expression) {
        try {
            return Optional.of((int)((NumericLiteral)expression).valueAsLong());
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> getString(Expression expression) {
        try {
            return Optional.of(((StringLiteral)expression).trimmedQuotesValue());
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public static Optional<CallExpression> getCall(Expression expression, String fqn) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.CALL_EXPR}) && CdkPredicate.isFqn(fqn).test(expression)) {
            return Optional.of((CallExpression)expression);
        }
        return Optional.empty();
    }

    public static Optional<ListLiteral> getListExpression(ExpressionFlow expression) {
        return expression.getExpression(CdkPredicate.isListLiteral()).map(ListLiteral.class::cast);
    }

    public static Optional<DictionaryLiteral> getDictionary(Expression expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})) {
            return Optional.of((DictionaryLiteral)expression);
        }
        return Optional.empty();
    }

    protected static Optional<ExpressionFlow> getArgument(SubscriptionContext ctx, CallExpression callExpression, String argumentName) {
        return CdkUtils.getArgument(ctx, callExpression, TreeUtils.argumentByKeyword((String)argumentName, (List)callExpression.arguments()));
    }

    protected static Optional<ExpressionFlow> getArgument(CallExpression callExpression, String argumentName) {
        return CdkUtils.getArgument(null, callExpression, TreeUtils.argumentByKeyword((String)argumentName, (List)callExpression.arguments()));
    }

    private static Optional<ExpressionFlow> getArgument(SubscriptionContext ctx, CallExpression callExpression, RegularArgument regArg) {
        List arguments = callExpression.arguments();
        Optional<ExpressionFlow> argument = Optional.ofNullable(regArg).map(RegularArgument::expression).map(expression -> ExpressionFlow.build(ctx, expression));
        if (argument.isEmpty()) {
            if (arguments.stream().anyMatch(UnpackingExpression.class::isInstance)) {
                return Optional.of(new UnresolvedExpressionFlow(ctx));
            }
        }
        return argument;
    }

    public static Optional<ExpressionFlow> getArgument(SubscriptionContext ctx, CallExpression callExpression, String argumentName, int argumentPosition) {
        return Optional.ofNullable(TreeUtils.nthArgumentOrKeyword((int)argumentPosition, (String)argumentName, (List)callExpression.arguments())).map(argument -> ExpressionFlow.build(ctx, argument.expression()));
    }

    public static Optional<ListLiteral> getList(ExpressionFlow flow) {
        return flow.getExpression(e -> e.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL})).map(ListLiteral.class::cast);
    }

    public static List<ExpressionFlow> getListElements(SubscriptionContext ctx, ListLiteral list) {
        return list.elements().expressions().stream().map(expression -> ExpressionFlow.build(ctx, expression)).collect(Collectors.toList());
    }

    public static Optional<DictionaryLiteral> getDictionary(ExpressionFlow flow) {
        return flow.getExpression(e -> e.is(new Tree.Kind[]{Tree.Kind.DICTIONARY_LITERAL})).map(DictionaryLiteral.class::cast);
    }

    public static Optional<ResolvedKeyValuePair> getDictionaryPair(SubscriptionContext ctx, DictionaryLiteral dict, String key) {
        return CdkUtils.getDictionaryPair(CdkUtils.resolveDictionary(ctx, dict), key);
    }

    public static Optional<ResolvedKeyValuePair> getDictionaryPair(List<ResolvedKeyValuePair> pairs, String key) {
        return pairs.stream().filter(pair -> pair.key.hasExpression(CdkPredicate.isString(key))).findFirst();
    }

    public static Optional<ExpressionFlow> getDictionaryValue(List<ResolvedKeyValuePair> pairs, String key) {
        return CdkUtils.getDictionaryPair(pairs, key).map(pair -> pair.value);
    }

    public static List<DictionaryLiteral> getDictionaryInList(SubscriptionContext ctx, ListLiteral listeners) {
        return CdkUtils.getListElements(ctx, listeners).stream().map(CdkUtils::getDictionary).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public static List<ResolvedKeyValuePair> resolveDictionary(SubscriptionContext ctx, DictionaryLiteral dict) {
        return dict.elements().stream().map(e -> CdkUtils.getKeyValuePair(ctx, e)).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    public static Optional<ResolvedKeyValuePair> getKeyValuePair(SubscriptionContext ctx, DictionaryLiteralElement element) {
        return element.is(new Tree.Kind[]{Tree.Kind.KEY_VALUE_PAIR}) ? Optional.of(ResolvedKeyValuePair.build(ctx, (KeyValuePair)element)) : Optional.empty();
    }

    static class ResolvedKeyValuePair {
        final ExpressionFlow key;
        final ExpressionFlow value;

        private ResolvedKeyValuePair(ExpressionFlow key, ExpressionFlow value) {
            this.key = key;
            this.value = value;
        }

        static ResolvedKeyValuePair build(SubscriptionContext ctx, KeyValuePair pair) {
            return new ResolvedKeyValuePair(ExpressionFlow.build(ctx, pair.key()), ExpressionFlow.build(ctx, pair.value()));
        }
    }

    static class UnresolvedExpressionFlow
    extends ExpressionFlow {
        private UnresolvedExpressionFlow(SubscriptionContext ctx) {
            super(ctx, new LinkedList<Expression>());
        }
    }

    static class ExpressionFlow {
        private static final String TAIL_MESSAGE = "Propagated setting.";
        private final SubscriptionContext ctx;
        private final Deque<Expression> locations;

        private ExpressionFlow(SubscriptionContext ctx, Deque<Expression> locations) {
            this.ctx = ctx;
            this.locations = locations;
        }

        protected static ExpressionFlow build(SubscriptionContext ctx, Expression expression) {
            LinkedList<Expression> locations = new LinkedList<Expression>();
            ExpressionFlow.resolveLocations(expression, locations);
            return new ExpressionFlow(ctx, locations);
        }

        static void resolveLocations(Expression expression, Deque<Expression> locations) {
            Expression singleAssignedValue;
            locations.add(expression);
            if (expression.is(new Tree.Kind[]{Tree.Kind.NAME}) && (singleAssignedValue = Expressions.singleAssignedValue((Name)expression)) != null && !locations.contains(singleAssignedValue)) {
                ExpressionFlow.resolveLocations(singleAssignedValue, locations);
            }
        }

        public void addIssue(String primaryMessage, IssueLocation ... secondaryLocations) {
            PythonCheck.PreciseIssue issue = this.ctx.addIssue(this.locations.getFirst().parent(), primaryMessage);
            this.locations.stream().skip(1L).forEach(expression -> issue.secondary(expression.parent(), TAIL_MESSAGE));
            Stream.of(secondaryLocations).forEach(arg_0 -> ((PythonCheck.PreciseIssue)issue).secondary(arg_0));
        }

        public void addIssueIf(Predicate<Expression> predicate, String primaryMessage, IssueLocation ... secondaryLocations) {
            if (this.hasExpression(predicate)) {
                this.addIssue(primaryMessage, secondaryLocations);
            }
        }

        public void addIssueIf(Predicate<Expression> predicate, String primaryMessage, CallExpression call) {
            if (this.hasExpression(predicate)) {
                this.ctx.addIssue((Tree)call.callee(), primaryMessage);
            }
        }

        public boolean hasExpression(Predicate<Expression> predicate) {
            return this.locations.stream().anyMatch(predicate);
        }

        public Optional<Expression> getExpression(Predicate<Expression> predicate) {
            return this.locations.stream().filter(predicate).findFirst();
        }

        public Deque<Expression> locations() {
            return this.locations;
        }

        public Expression getLast() {
            return this.locations().getLast();
        }

        public IssueLocation asSecondaryLocation(String message) {
            return IssueLocation.preciseLocation((Tree)this.getLast().parent(), (String)message);
        }

        public SubscriptionContext ctx() {
            return this.ctx;
        }
    }
}

