/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractIamPolicyStatementCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.checks.cdk.PolicyStatement;

@Rule(key="S6304")
public class ResourceAccessPolicyCheck
extends AbstractIamPolicyStatementCheck {
    private static final String MESSAGE = "Make sure granting access to all resources is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect";

    @Override
    protected void checkAllowingPolicyStatement(PolicyStatement policyStatement) {
        CdkUtils.ExpressionFlow actions = policyStatement.actions();
        CdkUtils.ExpressionFlow resources = policyStatement.resources();
        if (resources == null || actions == null || ResourceAccessPolicyCheck.hasOnlyKmsActions(actions)) {
            return;
        }
        Optional.ofNullable(ResourceAccessPolicyCheck.getSensitiveExpression(resources, CdkPredicate.isWildcard())).ifPresent(wildcard -> ResourceAccessPolicyCheck.reportWildcardResourceAndEffect(wildcard, policyStatement.effect()));
    }

    private static boolean hasOnlyKmsActions(CdkUtils.ExpressionFlow actions) {
        return ResourceAccessPolicyCheck.getSensitiveExpression(actions, ResourceAccessPolicyCheck.notStartsWith("kms:")) == null;
    }

    public static Predicate<Expression> notStartsWith(String expected) {
        return expression -> CdkUtils.getString(expression).filter(str -> !str.toLowerCase(Locale.ROOT).startsWith(expected)).isPresent();
    }

    private static void reportWildcardResourceAndEffect(CdkUtils.ExpressionFlow wildcard, @Nullable CdkUtils.ExpressionFlow effect) {
        PythonCheck.PreciseIssue issue = wildcard.ctx().addIssue((Tree)wildcard.getLast(), MESSAGE);
        if (effect != null) {
            issue.secondary(effect.asSecondaryLocation(SECONDARY_MESSAGE));
        }
    }
}

