/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;

@Rule(key="S6468")
public class ExceptionGroupCheck
extends PythonSubscriptionCheck {
    private static final Set<String> EXCEPTION_GROUP = Set.of("ExceptionGroup", "BaseExceptionGroup");
    private static final String MESSAGE = "Avoid catching %s exception with 'except*'";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_GROUP_CLAUSE, ctx -> {
            ExceptClause exceptClause = (ExceptClause)ctx.syntaxNode();
            Expression exception = exceptClause.exception();
            if (ExceptionGroupCheck.isExceptionGroup(exception)) {
                ExceptionGroupCheck.raiseIssue(ctx, exception);
            } else if (exception.is(new Tree.Kind[]{Tree.Kind.TUPLE})) {
                Tuple exceptionTuple = (Tuple)exception;
                for (Expression exceptionEl : exceptionTuple.elements()) {
                    if (!ExceptionGroupCheck.isExceptionGroup(exceptionEl)) continue;
                    ExceptionGroupCheck.raiseIssue(ctx, exceptionEl);
                }
            }
        });
    }

    private static boolean isExceptionGroup(Expression exception) {
        return exception.is(new Tree.Kind[]{Tree.Kind.NAME}) && EXCEPTION_GROUP.contains(((Name)exception).name());
    }

    private static void raiseIssue(SubscriptionContext ctx, Expression exception) {
        ctx.addIssue((Tree)exception, String.format(MESSAGE, ((Name)exception).name()));
    }
}

