/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;

public class Expressions {
    private static final Set<String> ZERO_VALUES = new HashSet<String>(Arrays.asList("0", "0.0", "0j"));

    private Expressions() {
    }

    public static boolean isFalsy(@Nullable Expression expression) {
        if (expression == null) {
            return false;
        }
        switch (expression.getKind()) {
            case NAME: {
                return "False".equals(((Name)expression).name());
            }
            case NONE: {
                return true;
            }
            case STRING_LITERAL: {
                return Expressions.unescape((StringLiteral)expression).isEmpty();
            }
            case NUMERIC_LITERAL: {
                return ZERO_VALUES.contains(((NumericLiteral)expression).valueAsString());
            }
            case LIST_LITERAL: {
                return ((ListLiteral)expression).elements().expressions().isEmpty();
            }
            case TUPLE: {
                return ((Tuple)expression).elements().isEmpty();
            }
            case DICTIONARY_LITERAL: {
                return ((DictionaryLiteral)expression).elements().isEmpty();
            }
        }
        return false;
    }

    public static boolean isTruthy(@Nullable Expression expression) {
        if (expression == null) {
            return false;
        }
        switch (expression.getKind()) {
            case NAME: {
                return "True".equals(((Name)expression).name());
            }
            case STRING_LITERAL: 
            case NUMERIC_LITERAL: 
            case LIST_LITERAL: 
            case TUPLE: 
            case DICTIONARY_LITERAL: 
            case SET_LITERAL: {
                return !Expressions.isFalsy(expression);
            }
        }
        return false;
    }

    public static Expression singleAssignedValue(Name name) {
        Symbol symbol = name.symbol();
        if (symbol == null) {
            return null;
        }
        Expression result = null;
        for (Usage usage : symbol.usages()) {
            if (usage.kind() == Usage.Kind.ASSIGNMENT_LHS) {
                if (result != null) {
                    return null;
                }
                Tree parent = usage.tree().parent();
                if (parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_LIST}) && ((ExpressionList)parent).expressions().size() == 1 && parent.parent().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
                    result = ((AssignmentStatement)parent.parent()).assignedValue();
                    continue;
                }
                return null;
            }
            if (!usage.isBindingUsage()) continue;
            return null;
        }
        return result;
    }

    public static Expression removeParentheses(@Nullable Expression expression) {
        if (expression == null) {
            return null;
        }
        Expression res = expression;
        while (res.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED})) {
            res = ((ParenthesizedExpression)res).expression();
        }
        return res;
    }

    public static String unescape(StringLiteral stringLiteral) {
        List elements = stringLiteral.stringElements();
        if (elements.size() == 1) {
            return Expressions.unescape((StringElement)elements.get(0));
        }
        return elements.stream().map(Expressions::unescape).collect(Collectors.joining());
    }

    public static String unescape(StringElement stringElement) {
        boolean isBytesLiteral;
        String lowerCasePrefix = stringElement.prefix().toLowerCase(Locale.ROOT);
        String valueWithoutQuotes = stringElement.trimmedQuotesValue();
        boolean isEscaped = lowerCasePrefix.indexOf(114) == -1;
        boolean bl = isBytesLiteral = lowerCasePrefix.indexOf(98) != -1;
        if (isEscaped) {
            valueWithoutQuotes = Expressions.unescapeString(valueWithoutQuotes, isBytesLiteral);
        }
        return valueWithoutQuotes;
    }

    static String unescapeString(String value, boolean isBytesLiteral) {
        if (value.indexOf(92) == -1) {
            return value;
        }
        int length = value.length();
        StringBuilder sb = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char ch = value.charAt(i);
            if (ch != '\\') {
                sb.append(ch);
                ++i;
                continue;
            }
            EscapeSequence escapeSequence = EscapeSequence.extract(value, i, isBytesLiteral);
            sb.append(escapeSequence.unescapedValue);
            i += escapeSequence.escapedLength;
        }
        return sb.toString();
    }

    private static class EscapeSequence {
        private static final int HEXADECIMAL_RADIX = 16;
        private static final EscapeSequence IGNORE = new EscapeSequence(1, "\\");
        private static final char[] UNESCAPED_CHAR = new char[119];
        private final int escapedLength;
        private final String unescapedValue;

        private EscapeSequence(int escapedLength, String unescapedValue) {
            this.escapedLength = escapedLength;
            this.unescapedValue = unescapedValue;
        }

        private static EscapeSequence extract(String value, int i, boolean isBytesLiteral) {
            char unescaped;
            if (i == value.length() - 1) {
                return IGNORE;
            }
            char nextChar = value.charAt(i + 1);
            char c = unescaped = nextChar < UNESCAPED_CHAR.length ? UNESCAPED_CHAR[nextChar] : (char)'\u0000';
            if (unescaped != '\u0000') {
                return new EscapeSequence(2, String.valueOf(unescaped));
            }
            if (nextChar == '\n') {
                return new EscapeSequence(2, "");
            }
            if (nextChar == '\r') {
                return new EscapeSequence(i + 2 < value.length() && value.charAt(i + 2) == '\n' ? 3 : 2, "");
            }
            if (nextChar == 'x') {
                return EscapeSequence.extractHexadecimal(value, i, 2);
            }
            if (nextChar == 'u' && !isBytesLiteral) {
                return EscapeSequence.extractHexadecimal(value, i, 4);
            }
            if (nextChar == 'U' && !isBytesLiteral) {
                return EscapeSequence.extractHexadecimal(value, i, 8);
            }
            if (nextChar == 'N') {
                return IGNORE;
            }
            return EscapeSequence.extractOctal(value, i);
        }

        private static EscapeSequence extractHexadecimal(String value, int i, int length) {
            if (i + 1 + length < value.length()) {
                try {
                    int hexValue = Integer.parseInt(value.substring(i + 2, i + 2 + length), 16);
                    return new EscapeSequence(2 + length, String.valueOf((char)hexValue));
                }
                catch (NumberFormatException ex) {
                    return IGNORE;
                }
            }
            return IGNORE;
        }

        private static EscapeSequence extractOctal(String value, int i) {
            int j;
            int octal = 0;
            int octalStart = value.charAt(i + 1) == 'o' ? i + 2 : i + 1;
            int len = 0;
            for (j = octalStart; len < 3 && j < value.length() && value.charAt(j) >= '0' && value.charAt(j) <= '7'; ++j, ++len) {
                octal = octal * 8 + (value.charAt(j) - 48);
            }
            if (len > 0) {
                return new EscapeSequence(j - i, String.valueOf((char)octal));
            }
            return IGNORE;
        }

        static {
            EscapeSequence.UNESCAPED_CHAR[92] = 92;
            EscapeSequence.UNESCAPED_CHAR[39] = 39;
            EscapeSequence.UNESCAPED_CHAR[34] = 34;
            EscapeSequence.UNESCAPED_CHAR[97] = 7;
            EscapeSequence.UNESCAPED_CHAR[98] = 8;
            EscapeSequence.UNESCAPED_CHAR[102] = 12;
            EscapeSequence.UNESCAPED_CHAR[110] = 10;
            EscapeSequence.UNESCAPED_CHAR[114] = 13;
            EscapeSequence.UNESCAPED_CHAR[116] = 9;
            EscapeSequence.UNESCAPED_CHAR[118] = 11;
        }
    }
}

