/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5527")
public class UnverifiedHostnameCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Enable server hostname verification on this SSL/TLS connection.";
    private static final Set<String> SECURE_BY_DEFAULT = new HashSet<String>(Arrays.asList("ssl.create_default_context", "ssl._create_default_https_context"));
    private static final Set<String> UNSECURE_BY_DEFAULT = new HashSet<String>(Arrays.asList("ssl._create_unverified_context", "ssl._create_stdlib_context"));
    private static Set<String> functionsToCheck;

    private static Set<String> functionsToCheck() {
        if (functionsToCheck == null) {
            functionsToCheck = new HashSet<String>();
            functionsToCheck.addAll(SECURE_BY_DEFAULT);
            functionsToCheck.addAll(UNSECURE_BY_DEFAULT);
        }
        return Collections.unmodifiableSet(functionsToCheck);
    }

    private static void checkSuspiciousCall(CallExpression callExpression, Symbol calleeSymbol, SubscriptionContext ctx) {
        Tree parent = TreeUtils.firstAncestorOfKind((Tree)callExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.CALL_EXPR});
        if (parent == null) {
            return;
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
            Expression lhs = (Expression)((ExpressionList)((AssignmentStatement)parent).lhsExpressions().get(0)).expressions().get(0);
            if (lhs instanceof HasSymbol) {
                Symbol symbol = ((HasSymbol)lhs).symbol();
                if (symbol == null) {
                    return;
                }
                if (UnverifiedHostnameCheck.isUnsafeContext(calleeSymbol, symbol)) {
                    ctx.addIssue((Tree)callExpression, MESSAGE);
                }
            }
        } else if (UnverifiedHostnameCheck.opensUnsecureConnection(calleeSymbol, (CallExpression)parent)) {
            ctx.addIssue((Tree)callExpression, MESSAGE);
        }
    }

    private static boolean isUnsafeContext(Symbol calleeSymbol, Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            AssignmentStatement assignmentStatement;
            QualifiedExpression qualifiedExpression;
            if (!usage.kind().equals((Object)Usage.Kind.OTHER) || (qualifiedExpression = (QualifiedExpression)TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) == null || !qualifiedExpression.name().name().equals("check_hostname") || (assignmentStatement = (AssignmentStatement)TreeUtils.firstAncestorOfKind((Tree)qualifiedExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) == null) continue;
            return Expressions.isFalsy(assignmentStatement.assignedValue());
        }
        return UNSECURE_BY_DEFAULT.contains(calleeSymbol.fullyQualifiedName());
    }

    private static boolean opensUnsecureConnection(Symbol calleeSymbol, CallExpression callExpr) {
        Symbol parentCalleeSymbol = callExpr.calleeSymbol();
        return parentCalleeSymbol != null && "urllib.request.urlopen".equals(parentCalleeSymbol.fullyQualifiedName()) && UNSECURE_BY_DEFAULT.contains(calleeSymbol.fullyQualifiedName());
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, UnverifiedHostnameCheck::checkCallExpression);
    }

    private static void checkCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol == null) {
            return;
        }
        if (UnverifiedHostnameCheck.functionsToCheck().contains(calleeSymbol.fullyQualifiedName())) {
            UnverifiedHostnameCheck.checkSuspiciousCall(callExpression, calleeSymbol, ctx);
        }
    }
}

