/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.InExpression;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.quickfix.IssueWithQuickFix;
import org.sonar.python.quickfix.PythonQuickFix;
import org.sonar.python.quickfix.PythonTextEdit;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1940")
public class BooleanCheckNotInvertedCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use the opposite operator (\"%s\") instead.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.NOT, ctx -> BooleanCheckNotInvertedCheck.checkNotExpression(ctx, (UnaryExpression)ctx.syntaxNode()));
    }

    private static void checkNotExpression(SubscriptionContext ctx, UnaryExpression original) {
        Expression negatedExpr = original.expression();
        while (negatedExpr.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED})) {
            negatedExpr = ((ParenthesizedExpression)negatedExpr).expression();
        }
        if (negatedExpr.is(new Tree.Kind[]{Tree.Kind.COMPARISON})) {
            BinaryExpression binaryExp = (BinaryExpression)negatedExpr;
            if (!binaryExp.leftOperand().is(new Tree.Kind[]{Tree.Kind.COMPARISON})) {
                String oppositeOperator = BooleanCheckNotInvertedCheck.oppositeOperator(binaryExp.operator());
                IssueWithQuickFix issue = (IssueWithQuickFix)ctx.addIssue((Tree)original, String.format(MESSAGE, oppositeOperator));
                BooleanCheckNotInvertedCheck.createQuickFix(issue, oppositeOperator, binaryExp, original);
            }
        } else if (negatedExpr.is(new Tree.Kind[]{Tree.Kind.IN, Tree.Kind.IS})) {
            BinaryExpression isInExpr = (BinaryExpression)negatedExpr;
            String oppositeOperator = BooleanCheckNotInvertedCheck.oppositeOperator(isInExpr.operator(), (Expression)isInExpr);
            IssueWithQuickFix issue = (IssueWithQuickFix)ctx.addIssue((Tree)original, String.format(MESSAGE, oppositeOperator));
            BooleanCheckNotInvertedCheck.createQuickFix(issue, oppositeOperator, isInExpr, original);
        }
    }

    private static String oppositeOperator(Token operator) {
        return BooleanCheckNotInvertedCheck.oppositeOperatorString(operator.value());
    }

    private static String oppositeOperator(Token operator, Expression expr) {
        Object s = operator.value();
        if (expr.is(new Tree.Kind[]{Tree.Kind.IS}) && ((IsExpression)expr).notToken() != null) {
            s = (String)s + " not";
        } else if (expr.is(new Tree.Kind[]{Tree.Kind.IN}) && ((InExpression)expr).notToken() != null) {
            s = "not " + (String)s;
        }
        return BooleanCheckNotInvertedCheck.oppositeOperatorString((String)s);
    }

    static String oppositeOperatorString(String stringOperator) {
        switch (stringOperator) {
            case ">": {
                return "<=";
            }
            case ">=": {
                return "<";
            }
            case "<": {
                return ">=";
            }
            case "<=": {
                return ">";
            }
            case "==": {
                return "!=";
            }
            case "!=": {
                return "==";
            }
            case "is": {
                return "is not";
            }
            case "is not": {
                return "is";
            }
            case "in": {
                return "not in";
            }
            case "not in": {
                return "in";
            }
        }
        throw new IllegalArgumentException("Unknown comparison operator : " + stringOperator);
    }

    private static void createQuickFix(IssueWithQuickFix issue, String oppositeOperator, BinaryExpression toUse, UnaryExpression notAncestor) {
        PythonTextEdit replaceEdit = BooleanCheckNotInvertedCheck.getReplaceEdit(toUse, oppositeOperator, notAncestor);
        PythonQuickFix quickFix = PythonQuickFix.newQuickFix((String)String.format("Use %s instead", oppositeOperator)).addTextEdit(new PythonTextEdit[]{replaceEdit}).build();
        issue.addQuickFix(quickFix);
    }

    private static PythonTextEdit getReplaceEdit(BinaryExpression toUse, String oppositeOperator, UnaryExpression notAncestor) {
        return PythonTextEdit.replace((Tree)notAncestor, (String)BooleanCheckNotInvertedCheck.getNewExpression(toUse, oppositeOperator));
    }

    private static String getNewExpression(BinaryExpression toUse, String oppositeOperator) {
        return BooleanCheckNotInvertedCheck.getText((Tree)toUse.leftOperand()) + " " + oppositeOperator + " " + BooleanCheckNotInvertedCheck.getText((Tree)toUse.rightOperand());
    }

    private static String getText(Tree tree) {
        return TreeUtils.tokens((Tree)tree).stream().map(Token::value).reduce("", (acc, currentChar) -> BooleanCheckNotInvertedCheck.isSpaceNotNeeded(acc, currentChar) ? acc + currentChar : acc + " " + currentChar);
    }

    private static boolean isSpaceNotNeeded(String acc, String toAdd) {
        return acc.isBlank() || acc.endsWith("(") || acc.endsWith("[") || !acc.endsWith(",") && "(".equals(toAdd) || !acc.endsWith(" ") && "[".equals(toAdd) || "]".equals(toAdd) || ")".equals(toAdd) || ",".equals(toAdd);
    }
}

