/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S5727")
public class ComparisonToNoneCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.IS, ctx -> ComparisonToNoneCheck.checkIdentityComparison(ctx, (IsExpression)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> ComparisonToNoneCheck.checkEqualityComparison(ctx, (BinaryExpression)ctx.syntaxNode()));
    }

    private static void checkEqualityComparison(SubscriptionContext ctx, BinaryExpression comparison) {
        String operator = comparison.operator().value();
        if (!"==".equals(operator) && !"!=".equals(operator)) {
            return;
        }
        InferredType left = comparison.leftOperand().type();
        InferredType right = comparison.rightOperand().type();
        if (CheckUtils.isNone(left) && CheckUtils.isNone(right)) {
            ComparisonToNoneCheck.addIssue(ctx, (Tree)comparison, operator + " comparison", "==".equals(operator));
        } else if (CheckUtils.isNone(left) && ComparisonToNoneCheck.cannotBeNone(right) || ComparisonToNoneCheck.cannotBeNone(left) && CheckUtils.isNone(right)) {
            ComparisonToNoneCheck.addIssue(ctx, (Tree)comparison, operator + " comparison", "!=".equals(operator));
        }
    }

    private static void checkIdentityComparison(SubscriptionContext ctx, IsExpression comparison) {
        InferredType right;
        InferredType left = comparison.leftOperand().type();
        if (!left.isIdentityComparableWith(right = comparison.rightOperand().type()) && (CheckUtils.isNone(left) || CheckUtils.isNone(right))) {
            ComparisonToNoneCheck.addIssue(ctx, (Tree)comparison, "identity check", comparison.notToken() != null);
        } else if (CheckUtils.isNone(left) && CheckUtils.isNone(right)) {
            ComparisonToNoneCheck.addIssue(ctx, (Tree)comparison, "identity check", comparison.notToken() == null);
        }
    }

    private static void addIssue(SubscriptionContext ctx, Tree tree, String comparisonKind, boolean result) {
        String resultAsString = result ? "True" : "False";
        ctx.addIssue(tree, String.format("Remove this %s; it will always be %s.", comparisonKind, resultAsString));
    }

    private static boolean cannotBeNone(InferredType type) {
        return !type.canBeOrExtend("NoneType");
    }
}

