/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.regex;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.python.checks.regex.AbstractRegexCheck;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.SyntaxError;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;

@Rule(key="S5856")
public class InvalidRegexCheck
extends AbstractRegexCheck {
    private static final String MESSAGE_FORMAT = "Fix the syntax error%s inside this regex.";

    @Override
    public void checkRegex(RegexParseResult regexParseResult, CallExpression regexFunctionCall) {
        List syntaxErrors = regexParseResult.getSyntaxErrors();
        if (!syntaxErrors.isEmpty()) {
            this.reportSyntaxErrors(syntaxErrors);
        }
    }

    private void reportSyntaxErrors(List<SyntaxError> syntaxErrors) {
        RegexSyntaxElement tree = syntaxErrors.get(0).getOffendingSyntaxElement();
        List<RegexIssueLocation> secondaries = syntaxErrors.stream().map(error -> new RegexIssueLocation(error.getOffendingSyntaxElement(), error.getMessage())).collect(Collectors.toList());
        String msg = String.format(MESSAGE_FORMAT, secondaries.size() > 1 ? "s" : "");
        this.addIssue(tree, msg, null, secondaries);
    }
}

