/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.tests;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S5905")
public class AssertOnTupleLiteralCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Fix this assertion on a tuple literal.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSERT_STMT, ctx -> {
            AssertStatement assertStatement = (AssertStatement)ctx.syntaxNode();
            if (assertStatement.condition().is(new Tree.Kind[]{Tree.Kind.TUPLE}) && assertStatement.message() == null) {
                ctx.addIssue((Tree)assertStatement.condition(), MESSAGE);
            }
        });
    }

    public PythonCheck.CheckScope scope() {
        return PythonCheck.CheckScope.ALL;
    }
}

