/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S1143")
public class JumpInFinallyCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.BREAK_STMT, ctx -> JumpInFinallyCheck.checkJumpStatement(ctx, "break"));
        context.registerSyntaxNodeConsumer(Tree.Kind.CONTINUE_STMT, ctx -> JumpInFinallyCheck.checkJumpStatement(ctx, "continue"));
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_STMT, ctx -> JumpInFinallyCheck.checkJumpStatement(ctx, "return"));
    }

    private static void checkJumpStatement(SubscriptionContext ctx, String keyword) {
        Tree tree = ctx.syntaxNode();
        if (JumpInFinallyCheck.isInFinally(tree)) {
            ctx.addIssue(tree, String.format("Remove this \"%s\" statement from this \"finally\" block.", keyword));
        }
    }

    private static boolean isInFinally(Tree tree) {
        for (Tree parent = tree.parent(); parent != null; parent = parent.parent()) {
            if (parent.is(new Tree.Kind[]{Tree.Kind.FINALLY_CLAUSE})) {
                return true;
            }
            if (parent.is(new Tree.Kind[]{Tree.Kind.FUNCDEF})) {
                return false;
            }
            if (!tree.is(new Tree.Kind[]{Tree.Kind.BREAK_STMT, Tree.Kind.CONTINUE_STMT}) || !parent.is(new Tree.Kind[]{Tree.Kind.FOR_STMT, Tree.Kind.WHILE_STMT})) continue;
            return false;
        }
        return false;
    }
}

