/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S1717")
public class BackslashInStringCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this \"\\\", add another \"\\\" to escape it, or make this a raw string.";
    private static final String VALID_ESCAPED_CHARACTERS = "abfnrtvxnNrtuU\\'\"0123456789\n\r";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_ELEMENT, ctx -> {
            StringElement pyStringLiteralTree = (StringElement)ctx.syntaxNode();
            String string = pyStringLiteralTree.value();
            int length = string.length();
            boolean isEscaped = false;
            boolean inPrefix = true;
            boolean isThreeQuotes = length > 5 && "\"\"".equals(string.substring(1, 3));
            for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                if (BackslashInStringCheck.isRawStringLiteral(inPrefix = BackslashInStringCheck.isInPrefix(inPrefix, c), c)) {
                    return;
                }
                if (isEscaped && VALID_ESCAPED_CHARACTERS.indexOf(c) == -1 && !BackslashInStringCheck.isBackslashedSpaceAfterInlineMarkup(isThreeQuotes, string, i, c)) {
                    ctx.addIssue((Tree)pyStringLiteralTree, MESSAGE);
                }
                isEscaped = c == '\\' && !isEscaped;
            }
        });
    }

    private static boolean isBackslashedSpaceAfterInlineMarkup(boolean isThreeQuotes, String string, int position, char current) {
        if (isThreeQuotes && current == ' ' && position > 6) {
            char twoCharactersBefore = string.charAt(position - 2);
            switch (twoCharactersBefore) {
                case '*': 
                case '_': 
                case '`': 
                case '|': {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean isInPrefix(boolean wasInPrefix, char currentChar) {
        return wasInPrefix && currentChar != '\"' && currentChar != '\'';
    }

    private static boolean isRawStringLiteral(boolean inPrefix, char c) {
        if (inPrefix) {
            return c == 'r' || c == 'R';
        }
        return false;
    }
}

