/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5708")
public class CaughtExceptionsCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Change this expression to be a class deriving from BaseException or a tuple of such classes.";
    private static final Set<String> NON_COMPLIANT_TYPES = new HashSet<String>(Arrays.asList("list", "set", "dict"));

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_CLAUSE, ctx -> {
            Expression exception = ((ExceptClause)ctx.syntaxNode()).exception();
            if (exception == null) {
                return;
            }
            TreeUtils.flattenTuples((Expression)exception).forEach(expression -> {
                if (!CaughtExceptionsCheck.canBeOrExtendBaseException(expression.type()) || expression instanceof HasSymbol && !CaughtExceptionsCheck.inheritsFromBaseException(((HasSymbol)expression).symbol())) {
                    ctx.addIssue((Tree)expression, MESSAGE);
                }
            });
        });
    }

    private static boolean canBeOrExtendBaseException(InferredType type) {
        if (NON_COMPLIANT_TYPES.stream().anyMatch(arg_0 -> ((InferredType)type).canOnlyBe(arg_0))) {
            return false;
        }
        if (type.canBeOrExtend("tuple")) {
            return true;
        }
        return type.canBeOrExtend("BaseException");
    }

    private static boolean inheritsFromBaseException(@Nullable Symbol symbol) {
        if (symbol == null || symbol.kind() != Symbol.Kind.CLASS) {
            return true;
        }
        ClassSymbol classSymbol = (ClassSymbol)symbol;
        return classSymbol.isOrExtends("BaseException") || classSymbol.hasUnresolvedTypeHierarchy();
    }
}

